/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGeneralPreferences;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class GetPreferences
implements RestReadView<AccountResource> {
    private final Provider<CurrentUser> self;
    private final Provider<ReviewDb> db;

    @Inject
    GetPreferences(Provider<CurrentUser> self, Provider<ReviewDb> db) {
        this.self = self;
        this.db = db;
    }

    public PreferenceInfo apply(AccountResource rsrc) throws AuthException, ResourceNotFoundException, OrmException {
        if (this.self.get() != rsrc.getUser() && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("restricted to administrator");
        }
        Account a = this.db.get().accounts().get(rsrc.getUser().getAccountId());
        if (a == null) {
            throw new ResourceNotFoundException();
        }
        return new PreferenceInfo(a.getGeneralPreferences());
    }

    static class PreferenceInfo {
        final String kind = "gerritcodereview#preferences";
        short changesPerPage;
        Boolean showSiteHeader;
        Boolean useFlashClipboard;
        AccountGeneralPreferences.DownloadScheme downloadScheme;
        AccountGeneralPreferences.DownloadCommand downloadCommand;
        Boolean copySelfOnEmail;
        AccountGeneralPreferences.DateFormat dateFormat;
        AccountGeneralPreferences.TimeFormat timeFormat;
        Boolean reversePatchSetOrder;
        Boolean showUsernameInReviewCategory;
        Boolean relativeDateInChangeTable;
        Boolean sizeBarInChangeTable;
        AccountGeneralPreferences.CommentVisibilityStrategy commentVisibilityStrategy;
        AccountGeneralPreferences.DiffView diffView;
        AccountGeneralPreferences.ChangeScreen changeScreen;

        PreferenceInfo(AccountGeneralPreferences p) {
            this.changesPerPage = p.getMaximumPageSize();
            this.showSiteHeader = p.isShowSiteHeader() ? Boolean.valueOf(true) : null;
            this.useFlashClipboard = p.isUseFlashClipboard() ? Boolean.valueOf(true) : null;
            this.downloadScheme = p.getDownloadUrl();
            this.downloadCommand = p.getDownloadCommand();
            this.copySelfOnEmail = p.isCopySelfOnEmails() ? Boolean.valueOf(true) : null;
            this.dateFormat = p.getDateFormat();
            this.timeFormat = p.getTimeFormat();
            this.reversePatchSetOrder = p.isReversePatchSetOrder() ? Boolean.valueOf(true) : null;
            this.showUsernameInReviewCategory = p.isShowUsernameInReviewCategory() ? Boolean.valueOf(true) : null;
            this.relativeDateInChangeTable = p.isRelativeDateInChangeTable() ? Boolean.valueOf(true) : null;
            this.sizeBarInChangeTable = p.isSizeBarInChangeTable() ? Boolean.valueOf(true) : null;
            this.commentVisibilityStrategy = p.getCommentVisibilityStrategy();
            this.diffView = p.getDiffView();
            this.changeScreen = p.getChangeScreen();
        }
    }
}

