/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupIncludeCache;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GroupIncludeCacheImpl
implements GroupIncludeCache {
    private static final Logger log = LoggerFactory.getLogger(GroupIncludeCacheImpl.class);
    private static final String BYINCLUDE_NAME = "groups_byinclude";
    private static final String MEMBERS_NAME = "groups_members";
    private static final String EXTERNAL_NAME = "groups_external";
    private final LoadingCache<AccountGroup.UUID, Set<AccountGroup.UUID>> membersOf;
    private final LoadingCache<AccountGroup.UUID, Set<AccountGroup.UUID>> memberIn;
    private final LoadingCache<String, Set<AccountGroup.UUID>> external;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.cache(GroupIncludeCacheImpl.BYINCLUDE_NAME, AccountGroup.UUID.class, new TypeLiteral<Set<AccountGroup.UUID>>(){}).loader(MemberInLoader.class);
                this.cache(GroupIncludeCacheImpl.MEMBERS_NAME, AccountGroup.UUID.class, new TypeLiteral<Set<AccountGroup.UUID>>(){}).loader(MembersOfLoader.class);
                this.cache(GroupIncludeCacheImpl.EXTERNAL_NAME, String.class, new TypeLiteral<Set<AccountGroup.UUID>>(){}).loader(AllExternalLoader.class);
                this.bind(GroupIncludeCacheImpl.class);
                this.bind(GroupIncludeCache.class).to(GroupIncludeCacheImpl.class);
            }
        };
    }

    @Inject
    GroupIncludeCacheImpl(@Named(value="groups_members") LoadingCache<AccountGroup.UUID, Set<AccountGroup.UUID>> membersOf, @Named(value="groups_byinclude") LoadingCache<AccountGroup.UUID, Set<AccountGroup.UUID>> memberIn, @Named(value="groups_external") LoadingCache<String, Set<AccountGroup.UUID>> external) {
        this.membersOf = membersOf;
        this.memberIn = memberIn;
        this.external = external;
    }

    @Override
    public Set<AccountGroup.UUID> membersOf(AccountGroup.UUID groupId) {
        try {
            return this.membersOf.get(groupId);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load members of group", e);
            return Collections.emptySet();
        }
    }

    @Override
    public Set<AccountGroup.UUID> memberIn(AccountGroup.UUID groupId) {
        try {
            return this.memberIn.get(groupId);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load included groups", e);
            return Collections.emptySet();
        }
    }

    @Override
    public void evictMembersOf(AccountGroup.UUID groupId) {
        if (groupId != null) {
            this.membersOf.invalidate(groupId);
        }
    }

    @Override
    public void evictMemberIn(AccountGroup.UUID groupId) {
        if (groupId != null) {
            this.memberIn.invalidate(groupId);
            if (!AccountGroup.isInternalGroup(groupId)) {
                this.external.invalidate(EXTERNAL_NAME);
            }
        }
    }

    @Override
    public Set<AccountGroup.UUID> allExternalMembers() {
        try {
            return this.external.get(EXTERNAL_NAME);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load set of non-internal groups", e);
            return Collections.emptySet();
        }
    }

    static class AllExternalLoader
    extends CacheLoader<String, Set<AccountGroup.UUID>> {
        private final SchemaFactory<ReviewDb> schema;

        @Inject
        AllExternalLoader(SchemaFactory<ReviewDb> sf) {
            this.schema = sf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<AccountGroup.UUID> load(String key) throws Exception {
            try (ReviewDb db = this.schema.open();){
                HashSet<AccountGroup.UUID> ids = Sets.newHashSet();
                for (AccountGroupById agi : db.accountGroupById().all()) {
                    if (AccountGroup.isInternalGroup(agi.getIncludeUUID())) continue;
                    ids.add(agi.getIncludeUUID());
                }
                ImmutableSet<AccountGroup.UUID> immutableSet = ImmutableSet.copyOf(ids);
                return immutableSet;
            }
        }
    }

    static class MemberInLoader
    extends CacheLoader<AccountGroup.UUID, Set<AccountGroup.UUID>> {
        private final SchemaFactory<ReviewDb> schema;

        @Inject
        MemberInLoader(SchemaFactory<ReviewDb> sf) {
            this.schema = sf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<AccountGroup.UUID> load(AccountGroup.UUID key) throws Exception {
            try (ReviewDb db = this.schema.open();){
                HashSet<AccountGroup.Id> ids = Sets.newHashSet();
                for (AccountGroupById agi : db.accountGroupById().byIncludeUUID(key)) {
                    ids.add(agi.getGroupId());
                }
                HashSet<AccountGroup.UUID> groupArray = Sets.newHashSet();
                for (AccountGroup g : db.accountGroups().get(ids)) {
                    groupArray.add(g.getGroupUUID());
                }
                ImmutableSet<AccountGroup.UUID> immutableSet = ImmutableSet.copyOf(groupArray);
                return immutableSet;
            }
        }
    }

    static class MembersOfLoader
    extends CacheLoader<AccountGroup.UUID, Set<AccountGroup.UUID>> {
        private final SchemaFactory<ReviewDb> schema;

        @Inject
        MembersOfLoader(SchemaFactory<ReviewDb> sf) {
            this.schema = sf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<AccountGroup.UUID> load(AccountGroup.UUID key) throws Exception {
            try (ReviewDb db = this.schema.open();){
                List<AccountGroup> group = db.accountGroups().byUUID(key).toList();
                if (group.size() != 1) {
                    Set<AccountGroup.UUID> set = Collections.emptySet();
                    return set;
                }
                HashSet<AccountGroup.UUID> ids = Sets.newHashSet();
                for (AccountGroupById agi : db.accountGroupById().byGroup(group.get(0).getId())) {
                    ids.add(agi.getIncludeUUID());
                }
                ImmutableSet<AccountGroup.UUID> immutableSet = ImmutableSet.copyOf(ids);
                return immutableSet;
            }
        }
    }
}

