/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.archive.TarFormat;
import org.eclipse.jgit.archive.Tbz2Format;
import org.eclipse.jgit.archive.TgzFormat;
import org.eclipse.jgit.archive.TxzFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum ArchiveFormat {
    TGZ("application/x-gzip", new TgzFormat()),
    TAR("application/x-tar", new TarFormat()),
    TBZ2("application/x-bzip2", new Tbz2Format()),
    TXZ("application/x-xz", new TxzFormat());

    static final Logger log;
    private final ArchiveCommand.Format<?> format;
    private final String mimeType;

    private ArchiveFormat(String mimeType, ArchiveCommand.Format<?> format) {
        this.format = format;
        this.mimeType = mimeType;
        ArchiveCommand.registerFormat(this.name(), format);
    }

    String getShortName() {
        return this.name().toLowerCase();
    }

    String getMimeType() {
        return this.mimeType;
    }

    String getDefaultSuffix() {
        return this.getSuffixes().iterator().next();
    }

    Iterable<String> getSuffixes() {
        return this.format.suffixes();
    }

    static Map<String, ArchiveFormat> init() {
        String[] formats = new String[ArchiveFormat.values().length];
        for (int i = 0; i < ArchiveFormat.values().length; ++i) {
            formats[i] = ArchiveFormat.values()[i].name();
        }
        LinkedHashMap<String, ArchiveFormat> exts = Maps.newLinkedHashMap();
        for (String name : formats) {
            try {
                ArchiveFormat format = ArchiveFormat.valueOf(name.toUpperCase());
                for (String ext : format.getSuffixes()) {
                    exts.put(ext, format);
                }
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid archive.format {}", (Object)name);
            }
        }
        return Collections.unmodifiableMap(exts);
    }

    static {
        log = LoggerFactory.getLogger(ArchiveFormat.class);
    }
}

