/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class DeleteReviewer
implements RestModifyView<ReviewerResource, Input> {
    private final Provider<ReviewDb> dbProvider;
    private final ChangeUpdate.Factory updateFactory;
    private final ApprovalsUtil approvalsUtil;
    private final ChangeIndexer indexer;
    private final IdentifiedUser.GenericFactory userFactory;

    @Inject
    DeleteReviewer(Provider<ReviewDb> dbProvider, ChangeUpdate.Factory updateFactory, ApprovalsUtil approvalsUtil, ChangeIndexer indexer, IdentifiedUser.GenericFactory userFactory) {
        this.dbProvider = dbProvider;
        this.updateFactory = updateFactory;
        this.approvalsUtil = approvalsUtil;
        this.indexer = indexer;
        this.userFactory = userFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response<?> apply(ReviewerResource rsrc, Input input) throws AuthException, ResourceNotFoundException, OrmException, IOException {
        ChangeControl control = rsrc.getControl();
        Change.Id changeId = rsrc.getChange().getId();
        ReviewDb db = this.dbProvider.get();
        ChangeUpdate update = this.updateFactory.create(rsrc.getControl());
        StringBuilder msg = new StringBuilder();
        db.changes().beginTransaction(changeId);
        try {
            ArrayList<PatchSetApproval> del = Lists.newArrayList();
            for (PatchSetApproval a : this.approvals(db, rsrc)) {
                if (control.canRemoveReviewer(a)) {
                    del.add(a);
                    if (!a.getPatchSetId().equals(control.getChange().currentPatchSetId()) || a.getValue() == 0) continue;
                    if (msg.length() == 0) {
                        msg.append("Removed the following approvals:\n\n");
                    }
                    msg.append("* ").append(a.getLabel()).append(DeleteReviewer.formatLabelValue(a.getValue())).append(" by ").append(this.userFactory.create(a.getAccountId()).getNameEmail()).append("\n");
                    continue;
                }
                throw new AuthException("delete not permitted");
            }
            if (del.isEmpty()) {
                throw new ResourceNotFoundException();
            }
            ChangeUtil.bumpRowVersionNotLastUpdatedOn(rsrc.getChange().getId(), db);
            db.patchSetApprovals().delete(del);
            update.removeReviewer(rsrc.getUser().getAccountId());
            if (msg.length() > 0) {
                ChangeMessage changeMessage = new ChangeMessage(new ChangeMessage.Key(rsrc.getChange().getId(), ChangeUtil.messageUUID(db)), ((IdentifiedUser)control.getCurrentUser()).getAccountId(), TimeUtil.nowTs(), rsrc.getChange().currentPatchSetId());
                changeMessage.setMessage(msg.toString());
                db.changeMessages().insert(Collections.singleton(changeMessage));
            }
            db.commit();
        }
        finally {
            db.rollback();
        }
        update.commit();
        this.indexer.index(db, rsrc.getChange());
        return Response.none();
    }

    private static String formatLabelValue(short value) {
        if (value > 0) {
            return "+" + value;
        }
        return Short.toString(value);
    }

    private Iterable<PatchSetApproval> approvals(ReviewDb db, ReviewerResource rsrc) throws OrmException {
        final Account.Id user = rsrc.getUser().getAccountId();
        return Iterables.filter(this.approvalsUtil.byChange(db, rsrc.getNotes()).values(), new Predicate<PatchSetApproval>(){

            @Override
            public boolean apply(PatchSetApproval input) {
                return user.equals(input.getAccountId());
            }
        });
    }

    public static class Input {
    }
}

