/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.restapi.CacheControl;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.patch.PatchSetInfoNotAvailableException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.concurrent.TimeUnit;

public class GetCommit
implements RestReadView<RevisionResource> {
    private final ChangeJson json;

    @Inject
    GetCommit(ChangeJson json) {
        this.json = json;
    }

    public Response<CommitInfo> apply(RevisionResource resource) throws ResourceNotFoundException, OrmException {
        try {
            Response<CommitInfo> r = Response.ok(this.json.toCommit(resource.getPatchSet()));
            if (resource.isCacheable()) {
                r.caching(CacheControl.PRIVATE(7L, TimeUnit.DAYS));
            }
            return r;
        }
        catch (PatchSetInfoNotAvailableException e) {
            throw new ResourceNotFoundException(e.getMessage());
        }
    }
}

