/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gerrit.extensions.events.GitReferenceUpdatedListener;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.MergeabilityCheckQueue;
import com.google.gerrit.server.change.MergeabilityChecksExecutor;
import com.google.gerrit.server.change.Mergeable;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.index.ChangeIndexer;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeabilityChecker
implements GitReferenceUpdatedListener {
    private static final Logger log = LoggerFactory.getLogger(MergeabilityChecker.class);
    private static final Function<Exception, IOException> MAPPER = new Function<Exception, IOException>(){

        @Override
        public IOException apply(Exception in) {
            if (in instanceof IOException) {
                return (IOException)in;
            }
            if (in instanceof ExecutionException && in.getCause() instanceof IOException) {
                return (IOException)in.getCause();
            }
            return new IOException(in);
        }
    };
    private final ThreadLocalRequestContext tl;
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final IdentifiedUser.GenericFactory identifiedUserFactory;
    private final ChangeControl.GenericFactory changeControlFactory;
    private final Provider<Mergeable> mergeable;
    private final ChangeIndexer indexer;
    private final ListeningExecutorService backgroundExecutor;
    private final ListeningExecutorService interactiveExecutor;
    private final MergeabilityCheckQueue mergeabilityCheckQueue;
    private final MetaDataUpdate.Server metaDataUpdateFactory;

    @Inject
    public MergeabilityChecker(ThreadLocalRequestContext tl, SchemaFactory<ReviewDb> schemaFactory, IdentifiedUser.GenericFactory identifiedUserFactory, ChangeControl.GenericFactory changeControlFactory, Provider<Mergeable> mergeable, ChangeIndexer indexer, @MergeabilityChecksExecutor(value=MergeabilityChecksExecutor.Priority.BACKGROUND) WorkQueue.Executor backgroundExecutor, @MergeabilityChecksExecutor(value=MergeabilityChecksExecutor.Priority.INTERACTIVE) WorkQueue.Executor interactiveExecutor, MergeabilityCheckQueue mergeabilityCheckQueue, MetaDataUpdate.Server metaDataUpdateFactory) {
        this.tl = tl;
        this.schemaFactory = schemaFactory;
        this.identifiedUserFactory = identifiedUserFactory;
        this.changeControlFactory = changeControlFactory;
        this.mergeable = mergeable;
        this.indexer = indexer;
        this.backgroundExecutor = MoreExecutors.listeningDecorator(backgroundExecutor);
        this.interactiveExecutor = MoreExecutors.listeningDecorator(interactiveExecutor);
        this.mergeabilityCheckQueue = mergeabilityCheckQueue;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
    }

    public Check newCheck() {
        return new Check();
    }

    @Override
    public void onGitReferenceUpdated(GitReferenceUpdatedListener.Event event) {
        String ref = event.getRefName();
        if (ref.startsWith("refs/heads/") || ref.equals("refs/meta/config")) {
            Branch.NameKey branch = new Branch.NameKey(new Project.NameKey(event.getProjectName()), ref);
            this.newCheck().addBranch(branch).runAsync();
        }
        if (ref.equals("refs/meta/config")) {
            Project.NameKey p = new Project.NameKey(event.getProjectName());
            try {
                ProjectConfig oldCfg = this.parseConfig(p, event.getOldObjectId());
                ProjectConfig newCfg = this.parseConfig(p, event.getNewObjectId());
                if (this.recheckMerges(oldCfg, newCfg)) {
                    this.newCheck().addProject(p).force().runAsync();
                }
            }
            catch (IOException | ConfigInvalidException e) {
                String msg = "Failed to update mergeability flags for project " + p.get() + " on update of " + "refs/meta/config";
                log.error(msg, e);
                throw new RuntimeException(msg, e);
            }
        }
    }

    private boolean recheckMerges(ProjectConfig oldCfg, ProjectConfig newCfg) {
        if (oldCfg == null || newCfg == null) {
            return true;
        }
        return !oldCfg.getProject().getSubmitType().equals((Object)newCfg.getProject().getSubmitType()) || oldCfg.getProject().getUseContentMerge() != newCfg.getProject().getUseContentMerge() || (oldCfg.getRulesId() == null ? newCfg.getRulesId() != null : !oldCfg.getRulesId().equals(newCfg.getRulesId()));
    }

    private ProjectConfig parseConfig(Project.NameKey p, String idStr) throws IOException, ConfigInvalidException, RepositoryNotFoundException {
        ObjectId id = ObjectId.fromString(idStr);
        if (ObjectId.zeroId().equals(id)) {
            return null;
        }
        return ProjectConfig.read(this.metaDataUpdateFactory.create(p), id);
    }

    private class Task
    implements Callable<Boolean> {
        private final Change change;
        private final boolean force;
        private ReviewDb reviewDb;

        Task(Change change, boolean force) {
            this.change = change;
            this.force = force;
        }

        @Override
        public Boolean call() throws Exception {
            MergeabilityChecker.this.mergeabilityCheckQueue.updatingMergeabilityFlag(this.change, this.force);
            RequestContext context = new RequestContext(){

                @Override
                public CurrentUser getCurrentUser() {
                    return MergeabilityChecker.this.identifiedUserFactory.create(Task.this.change.getOwner());
                }

                @Override
                public Provider<ReviewDb> getReviewDbProvider() {
                    return new Provider<ReviewDb>(){

                        @Override
                        public ReviewDb get() {
                            if (Task.this.reviewDb == null) {
                                try {
                                    Task.this.reviewDb = (ReviewDb)MergeabilityChecker.this.schemaFactory.open();
                                }
                                catch (OrmException e) {
                                    throw new ProvisionException("Cannot open ReviewDb", e);
                                }
                            }
                            return Task.this.reviewDb;
                        }
                    };
                }
            };
            RequestContext old = MergeabilityChecker.this.tl.setContext(context);
            ReviewDb db = context.getReviewDbProvider().get();
            try {
                PatchSet ps = db.patchSets().get(this.change.currentPatchSetId());
                if (ps == null) {
                    Boolean bl = false;
                    return bl;
                }
                Mergeable m = (Mergeable)MergeabilityChecker.this.mergeable.get();
                m.setForce(this.force);
                ChangeControl control = MergeabilityChecker.this.changeControlFactory.controlFor(this.change.getId(), context.getCurrentUser());
                Mergeable.MergeableInfo info = m.apply(new RevisionResource(new ChangeResource(control), ps));
                Boolean bl = this.change.isMergeable() != info.mergeable;
                return bl;
            }
            catch (ResourceConflictException e) {
                Boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                log.error(String.format("cannot update mergeability flag of change %d in project %s after update of %s", this.change.getId().get(), this.change.getDest().getParentKey(), this.change.getDest().get()), e);
                throw e;
            }
            finally {
                MergeabilityChecker.this.tl.setContext(old);
                if (this.reviewDb != null) {
                    this.reviewDb.close();
                    this.reviewDb = null;
                }
            }
        }
    }

    public class Check {
        private List<Change> changes = Lists.newArrayListWithExpectedSize(1);
        private List<Branch.NameKey> branches = Lists.newArrayListWithExpectedSize(1);
        private List<Project.NameKey> projects = Lists.newArrayListWithExpectedSize(1);
        private boolean force;
        private boolean reindex;
        private boolean interactive = true;

        private Check() {
        }

        public Check addChange(Change change) {
            this.changes.add(change);
            return this;
        }

        public Check addBranch(Branch.NameKey branch) {
            this.branches.add(branch);
            this.interactive = false;
            return this;
        }

        public Check addProject(Project.NameKey project) {
            this.projects.add(project);
            this.interactive = false;
            return this;
        }

        public Check reindex() {
            this.reindex = true;
            return this;
        }

        private Check force() {
            this.force = true;
            return this;
        }

        private ListeningExecutorService getExecutor() {
            return this.interactive ? MergeabilityChecker.this.interactiveExecutor : MergeabilityChecker.this.backgroundExecutor;
        }

        public CheckedFuture<?, IOException> runAsync() {
            final ListeningExecutorService executor = this.getExecutor();
            ListenableFuture<List<Change>> getChanges = this.branches.isEmpty() && this.projects.isEmpty() ? Futures.immediateFuture(this.changes) : executor.submit(new Callable<List<Change>>(){

                @Override
                public List<Change> call() throws OrmException {
                    return Check.this.getChanges();
                }
            });
            return Futures.makeChecked(Futures.transform(getChanges, new AsyncFunction<List<Change>, List<Object>>(){

                @Override
                public ListenableFuture<List<Object>> apply(List<Change> changes) {
                    ArrayList<ListenableFuture<Object>> result = Lists.newArrayListWithCapacity(changes.size());
                    for (final Change c : changes) {
                        ListenableFuture<Boolean> b = executor.submit(new Task(c, Check.this.force));
                        if (Check.this.reindex) {
                            result.add(Futures.transform(b, new AsyncFunction<Boolean, Object>(){

                                @Override
                                public ListenableFuture<Object> apply(Boolean indexUpdated) throws Exception {
                                    if (!indexUpdated.booleanValue()) {
                                        return MergeabilityChecker.this.indexer.indexAsync(c.getId());
                                    }
                                    return Futures.immediateFuture(null);
                                }
                            }));
                            continue;
                        }
                        result.add(b);
                    }
                    return Futures.allAsList(result);
                }
            }), MAPPER);
        }

        public void run() throws IOException {
            try {
                this.runAsync().checkedGet();
            }
            catch (Exception e) {
                Throwables.propagateIfPossible(e, IOException.class);
                throw (IOException)MAPPER.apply(e);
            }
        }

        private List<Change> getChanges() throws OrmException {
            try (ReviewDb db = (ReviewDb)MergeabilityChecker.this.schemaFactory.open();){
                ArrayList<Change> results = Lists.newArrayList();
                results.addAll(this.changes);
                for (Project.NameKey p : this.projects) {
                    Iterables.addAll(results, db.changes().byProjectOpenAll(p));
                }
                for (Branch.NameKey b : this.branches) {
                    Iterables.addAll(results, db.changes().byBranchOpenAll(b));
                }
                ArrayList<Change> arrayList = results;
                return arrayList;
            }
        }
    }
}

