/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.gerrit.common.ChangeHooks;
import com.google.gerrit.extensions.api.changes.RestoreInput;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.MergeabilityChecker;
import com.google.gerrit.server.mail.RestoredSender;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gwtorm.server.AtomicUpdate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Restore
implements RestModifyView<ChangeResource, RestoreInput>,
UiAction<ChangeResource> {
    private static final Logger log = LoggerFactory.getLogger(Restore.class);
    private final ChangeHooks hooks;
    private final RestoredSender.Factory restoredSenderFactory;
    private final Provider<ReviewDb> dbProvider;
    private final ChangeJson json;
    private final MergeabilityChecker mergeabilityChecker;

    @Inject
    Restore(ChangeHooks hooks, RestoredSender.Factory restoredSenderFactory, Provider<ReviewDb> dbProvider, ChangeJson json, MergeabilityChecker mergeabilityChecker) {
        this.hooks = hooks;
        this.restoredSenderFactory = restoredSenderFactory;
        this.dbProvider = dbProvider;
        this.json = json;
        this.mergeabilityChecker = mergeabilityChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeJson.ChangeInfo apply(ChangeResource req, RestoreInput input) throws AuthException, ResourceConflictException, OrmException, IOException {
        ChangeMessage message;
        ChangeControl control = req.getControl();
        IdentifiedUser caller = (IdentifiedUser)control.getCurrentUser();
        Change change = req.getChange();
        if (!control.canRestore()) {
            throw new AuthException("restore not permitted");
        }
        if (change.getStatus() != Change.Status.ABANDONED) {
            throw new ResourceConflictException("change is " + Restore.status(change));
        }
        ReviewDb db = this.dbProvider.get();
        db.changes().beginTransaction(change.getId());
        try {
            change = db.changes().atomicUpdate(change.getId(), new AtomicUpdate<Change>(){

                @Override
                public Change update(Change change) {
                    if (change.getStatus() == Change.Status.ABANDONED) {
                        change.setStatus(Change.Status.NEW);
                        ChangeUtil.updated(change);
                        return change;
                    }
                    return null;
                }
            });
            if (change == null) {
                throw new ResourceConflictException("change is " + Restore.status(db.changes().get(req.getChange().getId())));
            }
            message = this.newMessage(input, caller, change);
            db.changeMessages().insert(Collections.singleton(message));
            db.commit();
        }
        finally {
            db.rollback();
        }
        CheckedFuture<?, IOException> f = this.mergeabilityChecker.newCheck().addChange(change).reindex().runAsync();
        try {
            RestoredSender cm = this.restoredSenderFactory.create(change);
            cm.setFrom(caller.getAccountId());
            cm.setChangeMessage(message);
            cm.send();
        }
        catch (Exception e) {
            log.error("Cannot email update for change " + change.getChangeId(), e);
        }
        f.checkedGet();
        this.hooks.doChangeRestoredHook(change, caller.getAccount(), db.patchSets().get(change.currentPatchSetId()), Strings.emptyToNull(input.message), this.dbProvider.get());
        ChangeJson.ChangeInfo result = this.json.format(change);
        return result;
    }

    @Override
    public UiAction.Description getDescription(ChangeResource resource) {
        return new UiAction.Description().setLabel("Restore").setTitle("Restore the change").setVisible(resource.getChange().getStatus() == Change.Status.ABANDONED && resource.getControl().canRestore());
    }

    private ChangeMessage newMessage(RestoreInput input, IdentifiedUser caller, Change change) throws OrmException {
        StringBuilder msg = new StringBuilder();
        msg.append("Restored");
        if (!Strings.nullToEmpty(input.message).trim().isEmpty()) {
            msg.append("\n\n");
            msg.append(input.message.trim());
        }
        ChangeMessage message = new ChangeMessage(new ChangeMessage.Key(change.getId(), ChangeUtil.messageUUID(this.dbProvider.get())), caller.getAccountId(), change.getLastUpdatedOn(), change.currentPatchSetId());
        message.setMessage(msg.toString());
        return message;
    }

    private static String status(Change change) {
        return change != null ? change.getStatus().name().toLowerCase() : "deleted";
    }
}

