/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.rules.RulesCache;
import com.google.gerrit.server.account.AccountInfo;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.project.RuleEvalException;
import com.google.gerrit.server.project.SubmitRuleEvaluator;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.googlecode.prolog_cafe.lang.Term;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kohsuke.args4j.Option;

public class TestSubmitRule
implements RestModifyView<RevisionResource, Input> {
    private final ReviewDb db;
    private final ChangeData.Factory changeDataFactory;
    private final RulesCache rules;
    private final AccountInfo.Loader.Factory accountInfoFactory;
    @Option(name="--filters", usage="impact of filters in parent projects")
    private Filters filters = Filters.RUN;

    @Inject
    TestSubmitRule(ReviewDb db, ChangeData.Factory changeDataFactory, RulesCache rules, AccountInfo.Loader.Factory infoFactory) {
        this.db = db;
        this.changeDataFactory = changeDataFactory;
        this.rules = rules;
        this.accountInfoFactory = infoFactory;
    }

    public List<Record> apply(RevisionResource rsrc, Input input) throws AuthException, BadRequestException, OrmException {
        List<Term> results;
        if (input == null) {
            input = new Input();
        }
        if (input.rule != null && !this.rules.isProjectRulesEnabled()) {
            throw new AuthException("project rules are disabled");
        }
        input.filters = Objects.firstNonNull(input.filters, this.filters);
        SubmitRuleEvaluator evaluator = new SubmitRuleEvaluator(this.db, rsrc.getPatchSet(), rsrc.getControl().getProjectControl(), rsrc.getControl(), rsrc.getChange(), this.changeDataFactory.create(this.db, rsrc.getChange()), false, "locate_submit_rule", "can_submit", "locate_submit_filter", "filter_submit_results", input.filters == Filters.SKIP, input.rule != null ? new ByteArrayInputStream(input.rule.getBytes(StandardCharsets.UTF_8)) : null);
        try {
            results = TestSubmitRule.eval(evaluator);
        }
        catch (RuleEvalException e) {
            String msg = Joiner.on(": ").skipNulls().join(Iterables.transform(Throwables.getCausalChain(e), new Function<Throwable, String>(){

                @Override
                public String apply(Throwable in) {
                    return in.getMessage();
                }
            }));
            throw new BadRequestException("rule failed: " + msg);
        }
        if (results.isEmpty()) {
            throw new BadRequestException(String.format("rule %s has no solutions", evaluator.getSubmitRule().toString()));
        }
        List<SubmitRecord> records = rsrc.getControl().resultsToSubmitRecord(evaluator.getSubmitRule(), results);
        ArrayList<Record> out = Lists.newArrayListWithCapacity(records.size());
        AccountInfo.Loader accounts = this.accountInfoFactory.create(true);
        for (SubmitRecord r : records) {
            out.add(new Record(r, accounts));
        }
        accounts.fill();
        return out;
    }

    private static List<Term> eval(SubmitRuleEvaluator evaluator) throws RuleEvalException {
        return evaluator.evaluate();
    }

    static class None {
        None() {
        }
    }

    static class Record {
        SubmitRecord.Status status;
        String errorMessage;
        Map<String, AccountInfo> ok;
        Map<String, AccountInfo> reject;
        Map<String, None> need;
        Map<String, AccountInfo> may;
        Map<String, None> impossible;

        Record(SubmitRecord r, AccountInfo.Loader accounts) {
            this.status = r.status;
            this.errorMessage = r.errorMessage;
            if (r.labels != null) {
                for (SubmitRecord.Label n : r.labels) {
                    AccountInfo who = n.appliedBy != null ? accounts.get(n.appliedBy) : new AccountInfo(null);
                    this.label(n, who);
                }
            }
        }

        private void label(SubmitRecord.Label n, AccountInfo who) {
            switch (n.status) {
                case OK: {
                    if (this.ok == null) {
                        this.ok = Maps.newLinkedHashMap();
                    }
                    this.ok.put(n.label, who);
                    break;
                }
                case REJECT: {
                    if (this.reject == null) {
                        this.reject = Maps.newLinkedHashMap();
                    }
                    this.reject.put(n.label, who);
                    break;
                }
                case NEED: {
                    if (this.need == null) {
                        this.need = Maps.newLinkedHashMap();
                    }
                    this.need.put(n.label, new None());
                    break;
                }
                case MAY: {
                    if (this.may == null) {
                        this.may = Maps.newLinkedHashMap();
                    }
                    this.may.put(n.label, who);
                    break;
                }
                case IMPOSSIBLE: {
                    if (this.impossible == null) {
                        this.impossible = Maps.newLinkedHashMap();
                    }
                    this.impossible.put(n.label, new None());
                }
            }
        }
    }

    public static class Input {
        @DefaultInput
        public String rule;
        public Filters filters;
    }

    public static enum Filters {
        RUN,
        SKIP;

    }
}

