/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.changedetail;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetAncestor;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.PatchSetInserter;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.changedetail.PathConflictException;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class RebaseChange {
    private final ChangeControl.GenericFactory changeControlFactory;
    private final ReviewDb db;
    private final GitRepositoryManager gitManager;
    private final PersonIdent myIdent;
    private final MergeUtil.Factory mergeUtilFactory;
    private final PatchSetInserter.Factory patchSetInserterFactory;

    @Inject
    RebaseChange(ChangeControl.GenericFactory changeControlFactory, ReviewDb db, @GerritPersonIdent PersonIdent myIdent, GitRepositoryManager gitManager, MergeUtil.Factory mergeUtilFactory, PatchSetInserter.Factory patchSetInserterFactory) {
        this.changeControlFactory = changeControlFactory;
        this.db = db;
        this.gitManager = gitManager;
        this.myIdent = myIdent;
        this.mergeUtilFactory = mergeUtilFactory;
        this.patchSetInserterFactory = patchSetInserterFactory;
    }

    public void rebase(PatchSet.Id patchSetId, IdentifiedUser uploader) throws NoSuchChangeException, EmailException, OrmException, IOException, InvalidChangeOperationException {
        Change.Id changeId = patchSetId.getParentKey();
        ChangeControl changeControl = this.changeControlFactory.validateFor(changeId, (CurrentUser)uploader);
        if (!changeControl.canRebase()) {
            throw new InvalidChangeOperationException("Cannot rebase: New patch sets are not allowed to be added to change: " + changeId.toString());
        }
        Change change = changeControl.getChange();
        Repository git = null;
        RevWalk rw = null;
        ObjectInserter inserter = null;
        try {
            git = this.gitManager.openRepository(change.getProject());
            rw = new RevWalk(git);
            inserter = git.newObjectInserter();
            String baseRev = RebaseChange.findBaseRevision(patchSetId, this.db, change.getDest(), git, null, null, null);
            RevCommit baseCommit = rw.parseCommit(ObjectId.fromString(baseRev));
            PersonIdent committerIdent = uploader.newCommitterIdent(this.myIdent.getWhen(), this.myIdent.getTimeZone());
            this.rebase(git, rw, inserter, patchSetId, change, uploader, baseCommit, this.mergeUtilFactory.create(changeControl.getProjectControl().getProjectState(), true), committerIdent, true, true, PatchSetInserter.ValidatePolicy.GERRIT);
        }
        catch (PathConflictException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (inserter != null) {
                inserter.release();
            }
            if (rw != null) {
                rw.release();
            }
            if (git != null) {
                git.close();
            }
        }
    }

    private static String findBaseRevision(PatchSet.Id patchSetId, ReviewDb db, Branch.NameKey destBranch, Repository git, List<PatchSetAncestor> patchSetAncestors, List<PatchSet> depPatchSetList, List<Change> depChangeList) throws IOException, OrmException {
        String baseRev = null;
        if (patchSetAncestors == null) {
            patchSetAncestors = db.patchSetAncestors().ancestorsOf(patchSetId).toList();
        }
        if (patchSetAncestors.size() > 1) {
            throw new IOException("Cannot rebase a change with multiple parents. Parent commits: " + patchSetAncestors.toString());
        }
        if (patchSetAncestors.size() == 0) {
            throw new IOException("Cannot rebase a change without any parents (is this the initial commit?).");
        }
        RevId ancestorRev = patchSetAncestors.get(0).getAncestorRevision();
        if (depPatchSetList == null || depPatchSetList.size() != 1 || !depPatchSetList.get(0).getRevision().equals(ancestorRev)) {
            depPatchSetList = db.patchSets().byRevision(ancestorRev).toList();
        }
        for (PatchSet depPatchSet : depPatchSetList) {
            Change.Id depChangeId = depPatchSet.getId().getParentKey();
            Change depChange = depChangeList == null || depChangeList.size() != 1 || !depChangeList.get(0).getId().equals(depChangeId) ? db.changes().get(depChangeId) : depChangeList.get(0);
            if (!depChange.getDest().equals(destBranch)) continue;
            if (depChange.getStatus() == Change.Status.ABANDONED) {
                throw new IOException("Cannot rebase a change with an abandoned parent: " + depChange.getKey().toString());
            }
            if (!depChange.getStatus().isOpen()) break;
            if (depPatchSet.getId().equals(depChange.currentPatchSetId())) {
                throw new IOException("Change is already based on the latest patch set of the dependent change.");
            }
            PatchSet latestDepPatchSet = db.patchSets().get(depChange.currentPatchSetId());
            baseRev = latestDepPatchSet.getRevision().get();
            break;
        }
        if (baseRev == null) {
            Ref destRef = git.getRef(destBranch.get());
            if (destRef == null) {
                throw new IOException("The destination branch does not exist: " + destBranch.get());
            }
            baseRev = destRef.getObjectId().getName();
            if (baseRev.equals(ancestorRev.get())) {
                throw new IOException("Change is already up to date.");
            }
        }
        return baseRev;
    }

    public PatchSet rebase(Repository git, RevWalk revWalk, ObjectInserter inserter, PatchSet.Id patchSetId, Change change, IdentifiedUser uploader, RevCommit baseCommit, MergeUtil mergeUtil, PersonIdent committerIdent, boolean sendMail, boolean runHooks, PatchSetInserter.ValidatePolicy validate) throws NoSuchChangeException, OrmException, IOException, InvalidChangeOperationException, PathConflictException {
        if (!change.currentPatchSetId().equals(patchSetId)) {
            throw new InvalidChangeOperationException("patch set is not current");
        }
        PatchSet originalPatchSet = this.db.patchSets().get(patchSetId);
        ObjectId oldId = ObjectId.fromString(originalPatchSet.getRevision().get());
        ObjectId newId = this.rebaseCommit(git, inserter, revWalk.parseCommit(oldId), baseCommit, mergeUtil, committerIdent);
        RevCommit rebasedCommit = revWalk.parseCommit(newId);
        ChangeControl changeControl = this.changeControlFactory.validateFor(change, (CurrentUser)uploader);
        PatchSetInserter patchSetInserter = this.patchSetInserterFactory.create(git, revWalk, changeControl, rebasedCommit).setCopyLabels(true).setValidatePolicy(validate).setDraft(originalPatchSet.isDraft()).setUploader(uploader.getAccountId()).setSendMail(sendMail).setRunHooks(runHooks);
        PatchSet.Id newPatchSetId = patchSetInserter.getPatchSetId();
        ChangeMessage cmsg = new ChangeMessage(new ChangeMessage.Key(change.getId(), ChangeUtil.messageUUID(this.db)), uploader.getAccountId(), TimeUtil.nowTs(), patchSetId);
        cmsg.setMessage("Patch Set " + newPatchSetId.get() + ": Patch Set " + patchSetId.get() + " was rebased");
        Change newChange = patchSetInserter.setMessage(cmsg).insert();
        return this.db.patchSets().get(newChange.currentPatchSetId());
    }

    private ObjectId rebaseCommit(Repository git, ObjectInserter inserter, RevCommit original, RevCommit base, MergeUtil mergeUtil, PersonIdent committerIdent) throws IOException, PathConflictException {
        RevCommit parentCommit = original.getParent(0);
        if (base.equals(parentCommit)) {
            throw new IOException("Change is already up to date.");
        }
        ThreeWayMerger merger = mergeUtil.newThreeWayMerger(git, inserter);
        merger.setBase(parentCommit);
        merger.merge(original, base);
        if (merger.getResultTreeId() == null) {
            throw new PathConflictException("The change could not be rebased due to a path conflict during merge.");
        }
        CommitBuilder cb = new CommitBuilder();
        cb.setTreeId(merger.getResultTreeId());
        cb.setParentId(base);
        cb.setAuthor(original.getAuthorIdent());
        cb.setMessage(original.getFullMessage());
        cb.setCommitter(committerIdent);
        ObjectId objectId = inserter.insert(cb);
        inserter.flush();
        return objectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canRebase(RevisionResource r) {
        Repository git;
        try {
            git = this.gitManager.openRepository(r.getChange().getProject());
        }
        catch (RepositoryNotFoundException err) {
            return false;
        }
        catch (IOException err) {
            return false;
        }
        try {
            RebaseChange.findBaseRevision(r.getPatchSet().getId(), this.db, r.getChange().getDest(), git, null, null, null);
            boolean err = true;
            return err;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        catch (OrmException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            git.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canDoRebase(ReviewDb db, Change change, GitRepositoryManager gitManager, List<PatchSetAncestor> patchSetAncestors, List<PatchSet> depPatchSetList, List<Change> depChangeList) throws OrmException, RepositoryNotFoundException, IOException {
        try (Repository git = gitManager.openRepository(change.getProject());){
            RebaseChange.findBaseRevision(change.currentPatchSetId(), db, change.getDest(), git, patchSetAncestors, depPatchSetList, depChangeList);
            boolean bl = true;
            return bl;
        }
    }
}

