/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.LabelValue;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LabelNormalizer {
    private final ChangeControl.GenericFactory changeFactory;
    private final IdentifiedUser.GenericFactory userFactory;

    @Inject
    LabelNormalizer(ChangeControl.GenericFactory changeFactory, IdentifiedUser.GenericFactory userFactory) {
        this.changeFactory = changeFactory;
        this.userFactory = userFactory;
    }

    public Result normalize(Change change, Collection<PatchSetApproval> approvals) throws NoSuchChangeException {
        return this.normalize(this.changeFactory.controlFor(change, (CurrentUser)this.userFactory.create(change.getOwner())), approvals);
    }

    public Result normalize(ChangeControl ctl, Collection<PatchSetApproval> approvals) {
        ArrayList<PatchSetApproval> unchanged = Lists.newArrayListWithCapacity(approvals.size());
        ArrayList<PatchSetApproval> updated = Lists.newArrayListWithCapacity(approvals.size());
        ArrayList<PatchSetApproval> deleted = Lists.newArrayListWithCapacity(approvals.size());
        LabelTypes labelTypes = ctl.getLabelTypes();
        for (PatchSetApproval psa : approvals) {
            Change.Id changeId = psa.getKey().getParentKey().getParentKey();
            Preconditions.checkArgument(changeId.equals(ctl.getChange().getId()), "Approval %s does not match change %s", psa.getKey(), ctl.getChange().getKey());
            if (psa.isSubmit()) {
                unchanged.add(psa);
                continue;
            }
            LabelType label = labelTypes.byLabel(psa.getLabelId());
            if (label == null) {
                deleted.add(psa);
                continue;
            }
            PatchSetApproval copy = this.copy(psa);
            this.applyTypeFloor(label, copy);
            if (!this.applyRightFloor(ctl, label, copy)) {
                deleted.add(psa);
                continue;
            }
            if (copy.getValue() != psa.getValue()) {
                updated.add(copy);
                continue;
            }
            unchanged.add(psa);
        }
        return new Result(unchanged, updated, deleted);
    }

    public boolean canVote(ChangeControl ctl, LabelType lt, Account.Id id) {
        return !this.getRange(ctl, lt, id).isEmpty();
    }

    private PatchSetApproval copy(PatchSetApproval src) {
        return new PatchSetApproval(src.getPatchSetId(), src);
    }

    private PermissionRange getRange(ChangeControl ctl, LabelType lt, Account.Id id) {
        String permission = Permission.forLabel(lt.getName());
        IdentifiedUser user = this.userFactory.create(id);
        return ctl.forUser(user).getRange(permission);
    }

    private boolean applyRightFloor(ChangeControl ctl, LabelType lt, PatchSetApproval a) {
        PermissionRange range = this.getRange(ctl, lt, a.getAccountId());
        if (range.isEmpty()) {
            return false;
        }
        a.setValue((short)range.squash(a.getValue()));
        return true;
    }

    private void applyTypeFloor(LabelType lt, PatchSetApproval a) {
        LabelValue atMax;
        LabelValue atMin = lt.getMin();
        if (atMin != null && a.getValue() < atMin.getValue()) {
            a.setValue(atMin.getValue());
        }
        if ((atMax = lt.getMax()) != null && a.getValue() > atMax.getValue()) {
            a.setValue(atMax.getValue());
        }
    }

    public static class Result {
        private final ImmutableList<PatchSetApproval> unchanged;
        private final ImmutableList<PatchSetApproval> updated;
        private final ImmutableList<PatchSetApproval> deleted;

        @VisibleForTesting
        Result(List<PatchSetApproval> unchanged, List<PatchSetApproval> updated, List<PatchSetApproval> deleted) {
            this.unchanged = ImmutableList.copyOf(unchanged);
            this.updated = ImmutableList.copyOf(updated);
            this.deleted = ImmutableList.copyOf(deleted);
        }

        public ImmutableList<PatchSetApproval> getUnchanged() {
            return this.unchanged;
        }

        public ImmutableList<PatchSetApproval> getUpdated() {
            return this.updated;
        }

        public ImmutableList<PatchSetApproval> getDeleted() {
            return this.deleted;
        }

        public Iterable<PatchSetApproval> getNormalized() {
            return Iterables.concat(this.unchanged, this.updated);
        }

        public boolean equals(Object o) {
            if (o instanceof Result) {
                Result r = (Result)o;
                return Objects.equal(this.unchanged, r.unchanged) && Objects.equal(this.updated, r.updated) && Objects.equal(this.deleted, r.deleted);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.unchanged, this.updated, this.deleted);
        }

        public String toString() {
            return Objects.toStringHelper(this).add("unchanged", this.unchanged).add("updated", this.updated).add("deleted", this.deleted).toString();
        }
    }
}

