/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.client.AccountGroupMemberAudit;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.AddMembers;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.MemberResource;
import com.google.gerrit.server.util.TimeUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DeleteMembers
implements RestModifyView<GroupResource, AddMembers.Input> {
    private final Provider<AccountsCollection> accounts;
    private final AccountCache accountCache;
    private final ReviewDb db;
    private final Provider<CurrentUser> self;

    @Inject
    DeleteMembers(Provider<AccountsCollection> accounts, AccountCache accountCache, ReviewDb db, Provider<CurrentUser> self) {
        this.accounts = accounts;
        this.accountCache = accountCache;
        this.db = db;
        this.self = self;
    }

    public Response<?> apply(GroupResource resource, AddMembers.Input input) throws AuthException, MethodNotAllowedException, UnprocessableEntityException, OrmException {
        AccountGroup internalGroup = resource.toAccountGroup();
        if (internalGroup == null) {
            throw new MethodNotAllowedException();
        }
        input = AddMembers.Input.init(input);
        GroupControl control = resource.getControl();
        Map<Account.Id, AccountGroupMember> members = this.getMembers(internalGroup.getId());
        LinkedList<AccountGroupMember> toRemove = Lists.newLinkedList();
        for (String nameOrEmail : input.members) {
            Account a = this.accounts.get().parse(nameOrEmail).getAccount();
            if (!control.canRemoveMember(a.getId())) {
                throw new AuthException("Cannot delete member: " + a.getFullName());
            }
            AccountGroupMember m = members.remove(a.getId());
            if (m == null) continue;
            toRemove.add(m);
        }
        this.writeAudits(toRemove);
        this.db.accountGroupMembers().delete(toRemove);
        for (AccountGroupMember m : toRemove) {
            this.accountCache.evict(m.getAccountId());
        }
        return Response.none();
    }

    private void writeAudits(List<AccountGroupMember> toBeRemoved) throws OrmException {
        Account.Id me = ((IdentifiedUser)this.self.get()).getAccountId();
        LinkedList<AccountGroupMemberAudit> auditUpdates = Lists.newLinkedList();
        LinkedList<AccountGroupMemberAudit> auditInserts = Lists.newLinkedList();
        for (AccountGroupMember m : toBeRemoved) {
            AccountGroupMemberAudit audit = null;
            for (AccountGroupMemberAudit a : this.db.accountGroupMembersAudit().byGroupAccount(m.getAccountGroupId(), m.getAccountId())) {
                if (!a.isActive()) continue;
                audit = a;
                break;
            }
            if (audit != null) {
                audit.removed(me, TimeUtil.nowTs());
                auditUpdates.add(audit);
                continue;
            }
            audit = new AccountGroupMemberAudit(m, me, TimeUtil.nowTs());
            audit.removedLegacy();
            auditInserts.add(audit);
        }
        this.db.accountGroupMembersAudit().update(auditUpdates);
        this.db.accountGroupMembersAudit().insert(auditInserts);
    }

    private Map<Account.Id, AccountGroupMember> getMembers(AccountGroup.Id groupId) throws OrmException {
        HashMap<Account.Id, AccountGroupMember> members = Maps.newHashMap();
        for (AccountGroupMember m : this.db.accountGroupMembers().byGroup(groupId)) {
            members.put(m.getAccountId(), m);
        }
        return members;
    }

    static class DeleteMember
    implements RestModifyView<MemberResource, Input> {
        private final Provider<DeleteMembers> delete;

        @Inject
        DeleteMember(Provider<DeleteMembers> delete) {
            this.delete = delete;
        }

        public Response<?> apply(MemberResource resource, Input input) throws AuthException, MethodNotAllowedException, UnprocessableEntityException, OrmException {
            AddMembers.Input in = new AddMembers.Input();
            in._oneMember = resource.getMember().getAccountId().toString();
            return this.delete.get().apply(resource, in);
        }

        static class Input {
            Input() {
            }
        }
    }
}

