/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.gerrit.common.errors.InvalidNameException;
import com.google.gerrit.common.errors.NameAlreadyUsedException;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.PerformRenameGroup;
import com.google.gerrit.server.group.GroupResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;

public class PutName
implements RestModifyView<GroupResource, Input> {
    private final PerformRenameGroup.Factory performRenameGroupFactory;

    @Inject
    PutName(PerformRenameGroup.Factory performRenameGroupFactory) {
        this.performRenameGroupFactory = performRenameGroupFactory;
    }

    public String apply(GroupResource resource, Input input) throws MethodNotAllowedException, AuthException, BadRequestException, ResourceNotFoundException, ResourceConflictException, OrmException {
        if (resource.toAccountGroup() == null) {
            throw new MethodNotAllowedException();
        }
        if (!resource.getControl().isOwner()) {
            throw new AuthException("Not group owner");
        }
        if (input == null || Strings.isNullOrEmpty(input.name)) {
            throw new BadRequestException("name is required");
        }
        String newName = input.name.trim();
        if (resource.toAccountGroup().getName().equals(newName)) {
            return newName;
        }
        try {
            return this.performRenameGroupFactory.create().renameGroup((AccountGroup.Id)resource.toAccountGroup().getId(), (String)newName).group.getName();
        }
        catch (NoSuchGroupException e) {
            throw new ResourceNotFoundException();
        }
        catch (InvalidNameException e) {
            throw new BadRequestException(e.getMessage());
        }
        catch (NameAlreadyUsedException e) {
            throw new ResourceConflictException(e.getMessage());
        }
    }

    public static class Input {
        @DefaultInput
        public String name;
    }
}

