/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;

public class PutOwner
implements RestModifyView<GroupResource, Input> {
    private final Provider<GroupsCollection> groupsCollection;
    private final GroupCache groupCache;
    private final ReviewDb db;
    private final GroupJson json;

    @Inject
    PutOwner(Provider<GroupsCollection> groupsCollection, GroupCache groupCache, ReviewDb db, GroupJson json) {
        this.groupsCollection = groupsCollection;
        this.groupCache = groupCache;
        this.db = db;
        this.json = json;
    }

    public GroupJson.GroupInfo apply(GroupResource resource, Input input) throws ResourceNotFoundException, MethodNotAllowedException, AuthException, BadRequestException, UnprocessableEntityException, OrmException {
        AccountGroup group = resource.toAccountGroup();
        if (group == null) {
            throw new MethodNotAllowedException();
        }
        if (!resource.getControl().isOwner()) {
            throw new AuthException("Not group owner");
        }
        if (input == null || Strings.isNullOrEmpty(input.owner)) {
            throw new BadRequestException("owner is required");
        }
        group = this.db.accountGroups().get(group.getId());
        if (group == null) {
            throw new ResourceNotFoundException();
        }
        GroupDescription.Basic owner = this.groupsCollection.get().parse(input.owner);
        if (!group.getOwnerGroupUUID().equals(owner.getGroupUUID())) {
            group.setOwnerGroupUUID(owner.getGroupUUID());
            this.db.accountGroups().update(Collections.singleton(group));
            this.groupCache.evict(group);
        }
        return this.json.format(owner);
    }

    public static class Input {
        @DefaultInput
        public String owner;
    }
}

