/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.TrackingFooters;
import com.google.gerrit.server.index.FieldType;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import org.eclipse.jgit.lib.Config;

public abstract class FieldDef<I, T> {
    private final String name;
    private final FieldType<?> type;
    private final boolean stored;

    private FieldDef(String name, FieldType<?> type, boolean stored) {
        this.name = name;
        this.type = type;
        this.stored = stored;
    }

    public final String getName() {
        return this.name;
    }

    public final FieldType<?> getType() {
        return this.type;
    }

    public final boolean isStored() {
        return this.stored;
    }

    public abstract T get(I var1, FillArgs var2) throws OrmException;

    public abstract boolean isRepeatable();

    public static class FillArgs {
        final TrackingFooters trackingFooters;
        final boolean allowsDrafts;

        @Inject
        FillArgs(TrackingFooters trackingFooters, @GerritServerConfig Config cfg) {
            this.trackingFooters = trackingFooters;
            this.allowsDrafts = cfg == null ? true : cfg.getBoolean("change", "allowDrafts", true);
        }
    }

    public static abstract class Repeatable<I, T>
    extends FieldDef<I, Iterable<T>> {
        Repeatable(String name, FieldType<T> type, boolean stored) {
            super(name, type, stored);
        }

        @Override
        public final boolean isRepeatable() {
            return true;
        }
    }

    public static abstract class Single<I, T>
    extends FieldDef<I, T> {
        Single(String name, FieldType<T> type, boolean stored) {
            super(name, type, stored);
        }

        @Override
        public final boolean isRepeatable() {
            return false;
        }
    }
}

