/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail;

import com.google.gerrit.server.mail.Address;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public abstract class EmailHeader {
    public abstract boolean isEmpty();

    public abstract void write(Writer var1) throws IOException;

    static boolean needsQuotedPrintable(java.lang.String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) >= ' ' && '~' >= value.charAt(i)) continue;
            return true;
        }
        return false;
    }

    static boolean needsQuotedPrintableWithinPhrase(int cp) {
        switch (cp) {
            case 33: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 61: 
            case 95: {
                return false;
            }
        }
        return !(97 <= cp && cp <= 122 || 65 <= cp && cp <= 90) && (48 > cp || cp > 57);
    }

    static java.lang.String quotedPrintable(java.lang.String value) throws UnsupportedEncodingException {
        StringBuilder r = new StringBuilder();
        r.append("=?UTF-8?Q?");
        for (int i = 0; i < value.length(); ++i) {
            int cp = value.codePointAt(i);
            if (cp == 32) {
                r.append('_');
                continue;
            }
            if (EmailHeader.needsQuotedPrintableWithinPhrase(cp)) {
                byte[] buf;
                for (byte b : buf = new java.lang.String(Character.toChars(cp)).getBytes("UTF-8")) {
                    r.append('=');
                    r.append(Integer.toHexString(b >>> 4 & 0xF).toUpperCase());
                    r.append(Integer.toHexString(b & 0xF).toUpperCase());
                }
                continue;
            }
            r.append(Character.toChars(cp));
        }
        r.append("?=");
        return r.toString();
    }

    public static class AddressList
    extends EmailHeader {
        private final List<Address> list = new ArrayList<Address>();

        public AddressList() {
        }

        public AddressList(Address addr) {
            this.add(addr);
        }

        public List<Address> getAddressList() {
            return Collections.unmodifiableList(this.list);
        }

        public void add(Address addr) {
            this.list.add(addr);
        }

        void remove(java.lang.String email) {
            Iterator<Address> i = this.list.iterator();
            while (i.hasNext()) {
                if (!i.next().email.equals(email)) continue;
                i.remove();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public void write(Writer w) throws IOException {
            int len = 8;
            boolean firstAddress = true;
            boolean needComma = false;
            for (Address addr : this.list) {
                java.lang.String s = addr.toHeaderString();
                if (firstAddress) {
                    firstAddress = false;
                } else if (72 < len + s.length()) {
                    w.write(",\r\n\t");
                    len = 8;
                    needComma = false;
                }
                if (needComma) {
                    w.write(", ");
                }
                w.write(s);
                len += s.length();
                needComma = true;
            }
        }
    }

    public static class Date
    extends EmailHeader {
        private java.util.Date value;

        public Date(java.util.Date v) {
            this.value = v;
        }

        public java.util.Date getDate() {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return this.value == null;
        }

        @Override
        public void write(Writer w) throws IOException {
            SimpleDateFormat fmt = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
            w.write(fmt.format(this.value));
        }
    }

    public static class String
    extends EmailHeader {
        private java.lang.String value;

        public String(java.lang.String v) {
            this.value = v;
        }

        public java.lang.String getString() {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return this.value == null || this.value.length() == 0;
        }

        @Override
        public void write(Writer w) throws IOException {
            if (String.needsQuotedPrintable(this.value)) {
                w.write(String.quotedPrintable(this.value));
            } else {
                w.write(this.value);
            }
        }
    }
}

