/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail;

import com.google.common.collect.Sets;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.UserIdentity;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.EmailArguments;
import com.google.gerrit.server.mail.EmailHeader;
import com.google.gerrit.server.mail.RecipientType;
import com.google.gwtorm.server.OrmException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OutgoingEmail {
    private static final Logger log = LoggerFactory.getLogger(OutgoingEmail.class);
    private static final String HDR_TO = "To";
    private static final String HDR_CC = "CC";
    protected String messageClass;
    private final HashSet<Account.Id> rcptTo = new HashSet();
    private final Map<String, EmailHeader> headers;
    private final Set<Address> smtpRcptTo = Sets.newHashSet();
    private Address smtpFromAddress;
    private StringBuilder body;
    protected VelocityContext velocityContext;
    protected final EmailArguments args;
    protected Account.Id fromId;

    protected OutgoingEmail(EmailArguments ea, String mc) {
        this.args = ea;
        this.messageClass = mc;
        this.headers = new LinkedHashMap<String, EmailHeader>();
    }

    public void setFrom(Account.Id id) {
        this.fromId = id;
    }

    public void send() throws EmailException {
        if (!this.args.emailSender.isEnabled()) {
            return;
        }
        this.init();
        this.format();
        this.appendText(this.velocifyFile("Footer.vm"));
        if (this.shouldSendMessage()) {
            if (this.fromId != null) {
                Account fromUser = this.args.accountCache.get(this.fromId).getAccount();
                if (fromUser.getGeneralPreferences().isCopySelfOnEmails()) {
                    this.add(RecipientType.CC, this.fromId);
                } else if (this.rcptTo.remove(this.fromId)) {
                    String fromEmail = fromUser.getPreferredEmail();
                    Iterator<Address> i = this.smtpRcptTo.iterator();
                    while (i.hasNext()) {
                        if (!i.next().email.equals(fromEmail)) continue;
                        i.remove();
                    }
                    for (EmailHeader hdr : this.headers.values()) {
                        if (!(hdr instanceof EmailHeader.AddressList)) continue;
                        ((EmailHeader.AddressList)hdr).remove(fromEmail);
                    }
                    if (this.smtpRcptTo.isEmpty()) {
                        return;
                    }
                }
            }
            this.args.emailSender.send(this.smtpFromAddress, this.smtpRcptTo, this.headers, this.body.toString());
        }
    }

    protected abstract void format() throws EmailException;

    protected void init() throws EmailException {
        Address a;
        this.setupVelocityContext();
        this.smtpFromAddress = this.args.fromAddressGenerator.from(this.fromId);
        this.setHeader("Date", new Date());
        this.headers.put("From", new EmailHeader.AddressList(this.smtpFromAddress));
        this.headers.put(HDR_TO, new EmailHeader.AddressList());
        this.headers.put(HDR_CC, new EmailHeader.AddressList());
        this.setHeader("Message-ID", "");
        if (this.fromId != null && (a = this.toAddress(this.fromId)) != null && !this.smtpFromAddress.email.equals(a.email)) {
            this.setHeader("Reply-To", a.email);
        }
        this.setHeader("X-Gerrit-MessageType", this.messageClass);
        this.body = new StringBuilder();
        if (this.fromId != null && this.args.fromAddressGenerator.isGenericAddress(this.fromId)) {
            this.appendText(this.getFromLine());
        }
    }

    protected String getFromLine() {
        Account account = this.args.accountCache.get(this.fromId).getAccount();
        String name = account.getFullName();
        String email = account.getPreferredEmail();
        StringBuilder f = new StringBuilder();
        if (name != null && !name.isEmpty() || email != null && !email.isEmpty()) {
            f.append("From");
            if (name != null && !name.isEmpty()) {
                f.append(" ").append(name);
            }
            if (email != null && !email.isEmpty()) {
                f.append(" <").append(email).append(">");
            }
            f.append(":\n\n");
        }
        return f.toString();
    }

    public String getGerritHost() {
        if (this.getGerritUrl() != null) {
            try {
                return new URL(this.getGerritUrl()).getHost();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return SystemReader.getInstance().getHostname();
    }

    public String getSettingsUrl() {
        if (this.getGerritUrl() != null) {
            StringBuilder r = new StringBuilder();
            r.append(this.getGerritUrl());
            r.append("settings");
            return r.toString();
        }
        return null;
    }

    public String getGerritUrl() {
        return this.args.urlProvider.get();
    }

    protected void setVHeader(String name, String value) throws EmailException {
        this.setHeader(name, this.velocify(value));
    }

    protected void setHeader(String name, String value) {
        this.headers.put(name, new EmailHeader.String(value));
    }

    protected void setHeader(String name, Date date) {
        this.headers.put(name, new EmailHeader.Date(date));
    }

    protected void appendText(String text) {
        if (text != null) {
            this.body.append(text);
        }
    }

    protected String getNameFor(Account.Id accountId) {
        if (accountId == null) {
            return this.args.anonymousCowardName;
        }
        Account userAccount = this.args.accountCache.get(accountId).getAccount();
        String name = userAccount.getFullName();
        if (name == null) {
            name = userAccount.getPreferredEmail();
        }
        if (name == null) {
            name = this.args.anonymousCowardName + " #" + accountId;
        }
        return name;
    }

    public String getNameEmailFor(Account.Id accountId) {
        AccountState who = this.args.accountCache.get(accountId);
        String name = who.getAccount().getFullName();
        String email = who.getAccount().getPreferredEmail();
        if (name != null && email != null) {
            return name + " <" + email + ">";
        }
        if (name != null) {
            return name;
        }
        if (email != null) {
            return email;
        }
        return this.args.anonymousCowardName + " #" + accountId;
    }

    protected boolean shouldSendMessage() {
        if (this.body.length() == 0) {
            log.warn("Skipping delivery of email with no body");
            return false;
        }
        if (this.smtpRcptTo.isEmpty()) {
            log.info("Skipping delivery of email with no recipients");
            return false;
        }
        return this.smtpRcptTo.size() != 1 || this.rcptTo.size() != 1 || !this.rcptTo.contains(this.fromId);
    }

    protected void add(RecipientType rt, Collection<Account.Id> list) {
        for (Account.Id id : list) {
            this.add(rt, id);
        }
    }

    protected void add(RecipientType rt, UserIdentity who) {
        if (who != null && who.getAccount() != null) {
            this.add(rt, who.getAccount());
        }
    }

    protected void add(RecipientType rt, Account.Id to) {
        try {
            if (!this.rcptTo.contains(to) && this.isVisibleTo(to)) {
                this.rcptTo.add(to);
                this.add(rt, this.toAddress(to));
            }
        }
        catch (OrmException e) {
            log.error("Error reading database for account: " + to, e);
        }
    }

    protected boolean isVisibleTo(Account.Id to) throws OrmException {
        return true;
    }

    protected void add(RecipientType rt, Address addr) {
        if (addr != null && addr.email != null && addr.email.length() > 0) {
            if (this.args.emailSender.canEmail(addr.email)) {
                if (this.smtpRcptTo.add(addr)) {
                    switch (rt) {
                        case TO: {
                            ((EmailHeader.AddressList)this.headers.get(HDR_TO)).add(addr);
                            break;
                        }
                        case CC: {
                            ((EmailHeader.AddressList)this.headers.get(HDR_CC)).add(addr);
                            break;
                        }
                    }
                }
            } else {
                log.warn("Not emailing " + addr.email + " (prohibited by allowrcpt)");
            }
        }
    }

    private Address toAddress(Account.Id id) {
        Account a = this.args.accountCache.get(id).getAccount();
        String e = a.getPreferredEmail();
        if (!a.isActive() || e == null) {
            return null;
        }
        return new Address(a.getFullName(), e);
    }

    protected void setupVelocityContext() {
        this.velocityContext = new VelocityContext();
        this.velocityContext.put("email", this);
        this.velocityContext.put("messageClass", this.messageClass);
        this.velocityContext.put("StringUtils", StringUtils.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String velocify(String template) throws EmailException {
        RuntimeInstance runtime = this.args.velocityRuntime;
        String templateName = "OutgoingEmail";
        SimpleNode tree = runtime.parse(new StringReader(template), templateName);
        InternalContextAdapterImpl ica = new InternalContextAdapterImpl(this.velocityContext);
        ica.pushCurrentTemplateName(templateName);
        try {
            tree.init(ica, runtime);
            StringWriter w = new StringWriter();
            tree.render(ica, w);
            String string = w.toString();
            ica.popCurrentTemplateName();
            return string;
        }
        catch (Throwable throwable) {
            try {
                ica.popCurrentTemplateName();
                throw throwable;
            }
            catch (Exception e) {
                throw new EmailException("Cannot format velocity template: " + template, e);
            }
        }
    }

    protected String velocifyFile(String name) throws EmailException {
        try {
            RuntimeInstance runtime = this.args.velocityRuntime;
            if (runtime.getLoaderNameForResource(name) == null) {
                name = "com/google/gerrit/server/mail/" + name;
            }
            Template template = runtime.getTemplate(name, "UTF-8");
            StringWriter w = new StringWriter();
            template.merge(this.velocityContext, w);
            return w.toString();
        }
        catch (EmailException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EmailException("Cannot format velocity template " + name, e);
        }
    }

    public String joinStrings(Iterable<Object> in, String joiner) {
        return this.joinStrings(in.iterator(), joiner);
    }

    public String joinStrings(Iterator<Object> in, String joiner) {
        if (!in.hasNext()) {
            return "";
        }
        Object first = in.next();
        if (!in.hasNext()) {
            return OutgoingEmail.safeToString(first);
        }
        StringBuilder r = new StringBuilder();
        r.append(OutgoingEmail.safeToString(first));
        while (in.hasNext()) {
            r.append(joiner).append(OutgoingEmail.safeToString(in.next()));
        }
        return r.toString();
    }

    private static String safeToString(Object obj) {
        return obj != null ? obj.toString() : "";
    }
}

