/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.CommentLinkInfo;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.lib.Config;

public class CommentLinkProvider
implements Provider<List<CommentLinkInfo>> {
    private final Config cfg;

    @Inject
    CommentLinkProvider(@GerritServerConfig Config cfg) {
        this.cfg = cfg;
    }

    @Override
    public List<CommentLinkInfo> get() {
        Set<String> subsections = this.cfg.getSubsections("commentlink");
        ArrayList<CommentLinkInfo> cls = Lists.newArrayListWithCapacity(subsections.size());
        for (String name : subsections) {
            CommentLinkInfo cl = ProjectConfig.buildCommentLink(this.cfg, name, true);
            if (cl.isOverrideOnly()) {
                throw new ProvisionException("commentlink " + name + " empty except for \"enabled\"");
            }
            cls.add(cl);
        }
        return ImmutableList.copyOf(cls);
    }
}

