/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.server.query.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class RewritePredicate<T>
extends Predicate<T> {
    private boolean init;
    private String name = this.getClass().getSimpleName();
    private List<Predicate<T>> children = Collections.emptyList();

    protected void init(String name, Predicate<T> ... args) {
        this.init = true;
        this.name = name;
        this.children = ImmutableList.copyOf(args);
    }

    @Override
    public Predicate<T> copy(Collection<? extends Predicate<T>> children) {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof RewritePredicate) {
            RewritePredicate that = (RewritePredicate)other;
            if (this.init && that.init) {
                return this.getClass() == that.getClass() && this.name.equals(that.name) && this.children.equals(that.children);
            }
        }
        return this == other;
    }

    @Override
    public int hashCode() {
        int h = this.getClass().hashCode();
        if (!this.children.isEmpty()) {
            h *= 31;
            h += this.children.get(0).hashCode();
        }
        return h;
    }

    public final String toString() {
        StringBuilder r = new StringBuilder();
        r.append(this.name);
        if (!this.children.isEmpty()) {
            r.append("(");
            for (int i = 0; i < this.children.size(); ++i) {
                if (i != 0) {
                    r.append(" ");
                }
                r.append(this.children.get(i));
            }
            r.append(")");
        }
        return r.toString();
    }
}

