/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupName;
import com.google.gerrit.reviewdb.client.CurrentSchemaVersion;
import com.google.gerrit.reviewdb.client.SystemConfig;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.GroupUUID;
import com.google.gerrit.server.config.SitePath;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.schema.AllProjectsCreator;
import com.google.gerrit.server.schema.Current;
import com.google.gerrit.server.schema.DataSourceType;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gwtorm.jdbc.JdbcExecutor;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.PersonIdent;

public class SchemaCreator {
    @SitePath
    private final File site_path;
    private final AllProjectsCreator allProjectsCreator;
    private final PersonIdent serverUser;
    private final DataSourceType dataSourceType;
    private final int versionNbr;
    private AccountGroup admin;
    private AccountGroup batch;

    @Inject
    public SchemaCreator(SitePaths site, @Current SchemaVersion version, AllProjectsCreator ap, @GerritPersonIdent PersonIdent au, DataSourceType dst) {
        this(site.site_path, version, ap, au, dst);
    }

    public SchemaCreator(@SitePath File site, @Current SchemaVersion version, AllProjectsCreator ap, @GerritPersonIdent PersonIdent au, DataSourceType dst) {
        this.site_path = site;
        this.allProjectsCreator = ap;
        this.serverUser = au;
        this.dataSourceType = dst;
        this.versionNbr = version.getVersionNbr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(ReviewDb db) throws OrmException, IOException, ConfigInvalidException {
        JdbcSchema jdbc = (JdbcSchema)((Object)db);
        try (JdbcExecutor e = new JdbcExecutor(jdbc);){
            jdbc.updateSchema(e);
        }
        CurrentSchemaVersion sVer = CurrentSchemaVersion.create();
        sVer.versionNbr = this.versionNbr;
        db.schemaVersion().insert(Collections.singleton(sVer));
        this.initSystemConfig(db);
        this.allProjectsCreator.setAdministrators(GroupReference.forGroup(this.admin)).setBatchUsers(GroupReference.forGroup(this.batch)).create();
        this.dataSourceType.getIndexScript().run(db);
    }

    private AccountGroup newGroup(ReviewDb c, String name, AccountGroup.UUID uuid) throws OrmException {
        if (uuid == null) {
            uuid = GroupUUID.make(name, this.serverUser);
        }
        return new AccountGroup(new AccountGroup.NameKey(name), new AccountGroup.Id(c.nextAccountGroupId()), uuid);
    }

    private SystemConfig initSystemConfig(ReviewDb c) throws OrmException {
        this.admin = this.newGroup(c, "Administrators", null);
        this.admin.setDescription("Gerrit Site Administrators");
        c.accountGroups().insert(Collections.singleton(this.admin));
        c.accountGroupNames().insert(Collections.singleton(new AccountGroupName(this.admin)));
        this.batch = this.newGroup(c, "Non-Interactive Users", null);
        this.batch.setDescription("Users who perform batch actions on Gerrit");
        this.batch.setOwnerGroupUUID(this.admin.getGroupUUID());
        c.accountGroups().insert(Collections.singleton(this.batch));
        c.accountGroupNames().insert(Collections.singleton(new AccountGroupName(this.batch)));
        SystemConfig s = SystemConfig.create();
        try {
            s.sitePath = this.site_path.getCanonicalPath();
        }
        catch (IOException e) {
            s.sitePath = this.site_path.getAbsolutePath();
        }
        c.systemConfig().insert(Collections.singleton(s));
        return s;
    }
}

