/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.nosql;

import com.google.gwtorm.client.KeyUtil;
import com.google.gwtorm.nosql.AccessGen;
import com.google.gwtorm.nosql.NoSqlAccess;
import com.google.gwtorm.nosql.NoSqlSchema;
import com.google.gwtorm.schema.RelationModel;
import com.google.gwtorm.schema.SchemaModel;
import com.google.gwtorm.schema.java.JavaSchemaModel;
import com.google.gwtorm.server.GeneratedClassLoader;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.Schema;
import com.google.gwtorm.server.SchemaConstructorGen;
import com.google.gwtorm.server.SchemaFactory;
import com.google.gwtorm.server.SchemaGen;
import com.google.gwtorm.server.StandardKeyEncoder;

public abstract class NoSqlDatabase<T extends Schema, S extends NoSqlSchema, A extends NoSqlAccess>
implements SchemaFactory<T> {
    private final SchemaModel schemaModel;
    private final SchemaFactory<T> implFactory;

    protected NoSqlDatabase(Class<S> schemaBaseType, Class<A> accessBaseType, Class<T> appSchema) throws OrmException {
        this.schemaModel = new JavaSchemaModel(appSchema);
        GeneratedClassLoader loader = NoSqlDatabase.newLoader(appSchema);
        Class<T> impl = this.generate(schemaBaseType, accessBaseType, loader);
        this.implFactory = new SchemaConstructorGen<T>(loader, impl, this).create();
    }

    @Override
    public T open() throws OrmException {
        return this.implFactory.open();
    }

    public SchemaModel getSchemaModel() {
        return this.schemaModel;
    }

    private Class<T> generate(final Class<S> schemaBaseType, final Class<A> accessBaseType, GeneratedClassLoader loader) throws OrmException {
        return new SchemaGen<S>(loader, this.schemaModel, this.getClass(), schemaBaseType, new SchemaGen.AccessGenerator(){

            @Override
            public Class<?> create(GeneratedClassLoader loader, RelationModel rm) throws OrmException {
                return new AccessGen(loader, rm, schemaBaseType, accessBaseType).create();
            }
        }).create();
    }

    private static <T> GeneratedClassLoader newLoader(Class<T> schema) {
        return new GeneratedClassLoader(schema.getClassLoader());
    }

    static {
        KeyUtil.setEncoderImpl(new StandardKeyEncoder());
    }
}

