/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal.guava.collect;

import com.google.inject.internal.guava.annotations.$GwtCompatible;
import com.google.inject.internal.guava.base.$Preconditions;
import com.google.inject.internal.guava.collect.$BstBalancePolicy;
import com.google.inject.internal.guava.collect.$BstModificationResult;
import com.google.inject.internal.guava.collect.$BstNode;
import com.google.inject.internal.guava.collect.$BstNodeFactory;
import com.google.inject.internal.guava.collect.$BstSide;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@$GwtCompatible
final class $BstMutationResult<K, N extends $BstNode<K, N>> {
    private final K targetKey;
    @Nullable
    private N originalRoot;
    @Nullable
    private N changedRoot;
    private final $BstModificationResult<N> modificationResult;

    public static <K, N extends $BstNode<K, N>> $BstMutationResult<K, N> mutationResult(@Nullable K targetKey, @Nullable N originalRoot, @Nullable N changedRoot, $BstModificationResult<N> modificationResult) {
        return new $BstMutationResult<K, N>(targetKey, originalRoot, changedRoot, modificationResult);
    }

    private $BstMutationResult(@Nullable K targetKey, @Nullable N originalRoot, @Nullable N changedRoot, $BstModificationResult<N> modificationResult) {
        this.targetKey = targetKey;
        this.originalRoot = originalRoot;
        this.changedRoot = changedRoot;
        this.modificationResult = $Preconditions.checkNotNull(modificationResult);
    }

    public K getTargetKey() {
        return this.targetKey;
    }

    @Nullable
    public N getOriginalRoot() {
        return this.originalRoot;
    }

    @Nullable
    public N getChangedRoot() {
        return this.changedRoot;
    }

    @Nullable
    public N getOriginalTarget() {
        return this.modificationResult.getOriginalTarget();
    }

    @Nullable
    public N getChangedTarget() {
        return this.modificationResult.getChangedTarget();
    }

    $BstModificationResult.ModificationType modificationType() {
        return this.modificationResult.getType();
    }

    public $BstMutationResult<K, N> lift(N liftOriginalRoot, $BstSide side, $BstNodeFactory<N> nodeFactory, $BstBalancePolicy<N> balancePolicy) {
        assert (liftOriginalRoot != null & side != null & nodeFactory != null & balancePolicy != null);
        switch (this.modificationType()) {
            case IDENTITY: {
                this.changedRoot = liftOriginalRoot;
                this.originalRoot = this.changedRoot;
                return this;
            }
            case REBUILDING_CHANGE: 
            case REBALANCING_CHANGE: {
                this.originalRoot = liftOriginalRoot;
                Object resultLeft = (($BstNode)liftOriginalRoot).childOrNull($BstSide.LEFT);
                Object resultRight = (($BstNode)liftOriginalRoot).childOrNull($BstSide.RIGHT);
                switch (side) {
                    case LEFT: {
                        resultLeft = this.changedRoot;
                        break;
                    }
                    case RIGHT: {
                        resultRight = this.changedRoot;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                this.changedRoot = this.modificationType() == $BstModificationResult.ModificationType.REBUILDING_CHANGE ? nodeFactory.createNode(liftOriginalRoot, resultLeft, resultRight) : balancePolicy.balance(nodeFactory, liftOriginalRoot, resultLeft, resultRight);
                return this;
            }
        }
        throw new AssertionError();
    }
}

