/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.ChannelPipedInputStream;
import org.apache.sshd.common.channel.ChannelPipedOutputStream;

public class ChannelSession
extends AbstractClientChannel {
    private Thread streamPumper;

    public ChannelSession() {
        super("session");
    }

    public OpenFuture open() throws IOException {
        return this.internalOpen();
    }

    protected void doOpen() throws IOException {
        ChannelPipedOutputStream pos;
        ChannelPipedInputStream pis;
        this.invertedIn = new ChannelOutputStream(this, this.remoteWindow, this.log, SshConstants.Message.SSH_MSG_CHANNEL_DATA);
        if (this.out == null) {
            pis = new ChannelPipedInputStream(this.localWindow);
            pos = new ChannelPipedOutputStream(pis);
            this.out = pos;
            this.invertedOut = pis;
        }
        if (this.err == null) {
            pis = new ChannelPipedInputStream(this.localWindow);
            pos = new ChannelPipedOutputStream(pis);
            this.err = pos;
            this.invertedErr = pis;
        }
        if (this.in != null) {
            this.streamPumper = new Thread("ClientInputStreamPump"){

                public void run() {
                    ChannelSession.this.pumpInputStream();
                }
            };
            this.streamPumper.setDaemon(true);
            this.streamPumper.start();
        }
    }

    protected void postClose() {
        if (this.streamPumper != null) {
            this.streamPumper.interrupt();
            this.streamPumper = null;
        }
        super.postClose();
    }

    protected void pumpInputStream() {
        block4: {
            try {
                byte[] buffer = new byte[this.remoteWindow.getPacketSize()];
                while (!this.closeFuture.isClosed()) {
                    int len = this.securedRead(this.in, buffer, 0, buffer.length);
                    if (len > 0) {
                        this.invertedIn.write(buffer, 0, len);
                        this.invertedIn.flush();
                        continue;
                    }
                    this.sendEof();
                    break;
                }
            }
            catch (Exception e) {
                if (this.closing.get()) break block4;
                this.log.info("Caught exception", e);
                this.close(false);
            }
        }
    }

    protected int securedRead(InputStream in, byte[] buf, int off, int len) throws IOException {
        int n = 0;
        do {
            int nread;
            if ((nread = in.read(buf, off + n, Math.min(1024, len - n))) <= 0) {
                return n == 0 ? nread : n;
            }
            if ((n += nread) < len) continue;
            return n;
        } while (in.available() > 0);
        return n;
    }
}

