/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.DefaultCloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.BufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannel
implements Channel {
    public static final int DEFAULT_WINDOW_SIZE = 0x200000;
    public static final int DEFAULT_PACKET_SIZE = 32768;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Object lock = new Object();
    protected final Window localWindow = new Window(this, null, this.getClass().getName().contains(".client."), true);
    protected final Window remoteWindow = new Window(this, null, this.getClass().getName().contains(".client."), false);
    protected Session session;
    protected int id;
    protected int recipient;
    protected final CloseFuture closeFuture = new DefaultCloseFuture(this.lock);
    protected volatile boolean eof;
    protected final AtomicBoolean closing = new AtomicBoolean();
    protected boolean closedByOtherSide;

    public int getId() {
        return this.id;
    }

    public int getRecipient() {
        return this.recipient;
    }

    public Window getLocalWindow() {
        return this.localWindow;
    }

    public Window getRemoteWindow() {
        return this.remoteWindow;
    }

    public Session getSession() {
        return this.session;
    }

    public void handleRequest(Buffer buffer) throws IOException {
        throw new IllegalStateException();
    }

    public void init(Session session, int id) {
        this.session = session;
        this.id = id;
        this.configureWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStateChanged() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public CloseFuture close(boolean immediately) {
        if (this.closing.compareAndSet(false, true)) {
            if (immediately) {
                this.log.debug("Closing channel {} immediately", this.id);
                this.preClose(immediately).addListener(new SshFutureListener<CloseFuture>(){

                    @Override
                    public void operationComplete(CloseFuture future) {
                        AbstractChannel.this.postClose();
                        AbstractChannel.this.closeFuture.setClosed();
                        AbstractChannel.this.notifyStateChanged();
                        AbstractChannel.this.session.unregisterChannel(AbstractChannel.this);
                    }
                });
            } else {
                this.log.debug("Closing channel {} gracefully", this.id);
                this.preClose(immediately).addListener(new SshFutureListener<CloseFuture>(){

                    @Override
                    public void operationComplete(CloseFuture future) {
                        AbstractChannel.this.log.debug("Send SSH_MSG_CHANNEL_CLOSE on channel {}", AbstractChannel.this.id);
                        Buffer buffer = AbstractChannel.this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_CLOSE, 0);
                        buffer.putInt(AbstractChannel.this.recipient);
                        try {
                            AbstractChannel.this.session.writePacket(buffer).addListener(new SshFutureListener<IoWriteFuture>(){

                                @Override
                                public void operationComplete(IoWriteFuture future) {
                                    if (AbstractChannel.this.closedByOtherSide) {
                                        AbstractChannel.this.log.debug("Message SSH_MSG_CHANNEL_CLOSE written on channel {}", AbstractChannel.this.id);
                                        AbstractChannel.this.postClose();
                                        AbstractChannel.this.closeFuture.setClosed();
                                        AbstractChannel.this.notifyStateChanged();
                                    }
                                }
                            });
                        }
                        catch (IOException e) {
                            AbstractChannel.this.log.debug("Exception caught while writing SSH_MSG_CHANNEL_CLOSE packet on channel " + AbstractChannel.this.id, e);
                            AbstractChannel.this.postClose();
                            AbstractChannel.this.closeFuture.setClosed();
                            AbstractChannel.this.notifyStateChanged();
                        }
                    }
                });
            }
        }
        return this.closeFuture;
    }

    public void handleClose() throws IOException {
        this.log.debug("Received SSH_MSG_CHANNEL_CLOSE on channel {}", this.id);
        boolean bl = this.closedByOtherSide = !this.closing.get();
        if (this.closedByOtherSide) {
            this.close(false);
        } else {
            this.postClose();
            this.closeFuture.setClosed();
            this.notifyStateChanged();
        }
    }

    protected CloseFuture preClose(boolean immediately) {
        DefaultCloseFuture future = new DefaultCloseFuture(this.lock);
        future.setClosed();
        return future;
    }

    protected void postClose() {
    }

    protected void writePacket(Buffer buffer) throws IOException {
        if (!this.closing.get()) {
            this.session.writePacket(buffer);
        } else {
            this.log.debug("Discarding output packet because channel is being closed");
        }
    }

    public void handleData(Buffer buffer) throws IOException {
        int len = buffer.getInt();
        if (len < 0 || len > 65536) {
            throw new IllegalStateException("Bad item length: " + len);
        }
        this.log.debug("Received SSH_MSG_CHANNEL_DATA on channel {}", this.id);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Received channel data: {}", (Object)BufferUtils.printHex(buffer.array(), buffer.rpos(), len));
        }
        this.doWriteData(buffer.array(), buffer.rpos(), len);
    }

    public void handleExtendedData(Buffer buffer) throws IOException {
        int ex = buffer.getInt();
        if (ex != 1) {
            this.log.debug("Send SSH_MSG_CHANNEL_FAILURE on channel {}", this.id);
            buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_FAILURE, 0);
            buffer.putInt(this.recipient);
            this.writePacket(buffer);
            return;
        }
        int len = buffer.getInt();
        if (len < 0 || len > 65536) {
            throw new IllegalStateException("Bad item length: " + len);
        }
        this.log.debug("Received SSH_MSG_CHANNEL_EXTENDED_DATA on channel {}", this.id);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Received channel extended data: {}", (Object)BufferUtils.printHex(buffer.array(), buffer.rpos(), len));
        }
        this.doWriteExtendedData(buffer.array(), buffer.rpos(), len);
    }

    public void handleEof() throws IOException {
        this.log.debug("Received SSH_MSG_CHANNEL_EOF on channel {}", this.id);
        this.eof = true;
        this.notifyStateChanged();
    }

    public void handleWindowAdjust(Buffer buffer) throws IOException {
        this.log.debug("Received SSH_MSG_CHANNEL_WINDOW_ADJUST on channel {}", this.id);
        int window = buffer.getInt();
        this.remoteWindow.expand(window);
    }

    public void handleFailure() throws IOException {
        this.log.debug("Received SSH_MSG_CHANNEL_FAILURE on channel {}", this.id);
    }

    protected abstract void doWriteData(byte[] var1, int var2, int var3) throws IOException;

    protected abstract void doWriteExtendedData(byte[] var1, int var2, int var3) throws IOException;

    protected void sendEof() throws IOException {
        this.log.debug("Send SSH_MSG_CHANNEL_EOF on channel {}", this.id);
        Buffer buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_EOF, 0);
        buffer.putInt(this.recipient);
        this.writePacket(buffer);
    }

    protected void configureWindow() {
        int window = this.session.getIntProperty("window-size", 0x200000);
        int packet = this.session.getIntProperty("packet-size", 32768);
        this.localWindow.init(window, packet);
    }

    protected void sendWindowAdjust(int len) throws IOException {
        this.log.debug("Send SSH_MSG_CHANNEL_WINDOW_ADJUST on channel {}", this.id);
        Buffer buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_WINDOW_ADJUST, 0);
        buffer.putInt(this.recipient);
        buffer.putInt(len);
        this.writePacket(buffer);
    }
}

