/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.mina;

import java.util.HashMap;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IdleStatus;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoService;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.mina.MinaSession;
import org.apache.sshd.common.io.mina.MinaSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MinaService
implements IoService,
org.apache.mina.core.service.IoHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final FactoryManager manager;
    protected final IoHandler handler;

    public MinaService(FactoryManager manager, IoHandler handler) {
        this.manager = manager;
        this.handler = handler;
    }

    public int getNioWorkers() {
        int nb;
        String nioWorkers = this.manager.getProperties().get("nio-workers");
        if (nioWorkers != null && nioWorkers.length() > 0 && (nb = Integer.parseInt(nioWorkers)) > 0) {
            return nb;
        }
        return FactoryManager.DEFAULT_NIO_WORKERS;
    }

    protected abstract org.apache.mina.core.service.IoService getIoService();

    @Override
    public void dispose() {
        this.getIoService().dispose();
    }

    @Override
    public Map<Long, IoSession> getManagedSessions() {
        HashMap<Long, org.apache.mina.core.session.IoSession> mina = new HashMap<Long, org.apache.mina.core.session.IoSession>(this.getIoService().getManagedSessions());
        HashMap<Long, IoSession> sessions = new HashMap<Long, IoSession>();
        for (Long id : mina.keySet()) {
            sessions.put(id, this.getSession((org.apache.mina.core.session.IoSession)mina.get(id)));
        }
        return sessions;
    }

    @Override
    public void sessionCreated(org.apache.mina.core.session.IoSession session) throws Exception {
        MinaSession ioSession = new MinaSession(this, session);
        session.setAttribute(IoSession.class, ioSession);
        this.handler.sessionCreated(ioSession);
    }

    @Override
    public void sessionOpened(org.apache.mina.core.session.IoSession session) throws Exception {
    }

    @Override
    public void sessionClosed(org.apache.mina.core.session.IoSession session) throws Exception {
        this.handler.sessionClosed(this.getSession(session));
    }

    @Override
    public void sessionIdle(org.apache.mina.core.session.IoSession session, IdleStatus status) throws Exception {
    }

    @Override
    public void exceptionCaught(org.apache.mina.core.session.IoSession session, Throwable cause) throws Exception {
        this.handler.exceptionCaught(this.getSession(session), cause);
    }

    @Override
    public void messageReceived(org.apache.mina.core.session.IoSession session, Object message) throws Exception {
        this.handler.messageReceived(this.getSession(session), MinaSupport.asReadable((IoBuffer)message));
    }

    @Override
    public void messageSent(org.apache.mina.core.session.IoSession session, Object message) throws Exception {
    }

    protected IoSession getSession(org.apache.mina.core.session.IoSession session) {
        return (IoSession)session.getAttribute(IoSession.class);
    }
}

