/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.dircache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.dircache.InvalidPathException;
import org.eclipse.jgit.errors.CheckoutConflictException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.IndexWriteException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.io.AutoCRLFOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirCacheCheckout {
    private Repository repo;
    private HashMap<String, ObjectId> updated = new HashMap();
    private ArrayList<String> conflicts = new ArrayList();
    private ArrayList<String> removed = new ArrayList();
    private ObjectId mergeCommitTree;
    private DirCache dc;
    private DirCacheBuilder builder;
    private NameConflictTreeWalk walk;
    private ObjectId headCommitTree;
    private WorkingTreeIterator workingTree;
    private boolean failOnConflict = true;
    private ArrayList<String> toBeDeleted = new ArrayList();

    public Map<String, ObjectId> getUpdated() {
        return this.updated;
    }

    public List<String> getConflicts() {
        return this.conflicts;
    }

    public List<String> getToBeDeleted() {
        return this.toBeDeleted;
    }

    public List<String> getRemoved() {
        return this.removed;
    }

    public DirCacheCheckout(Repository repo, ObjectId headCommitTree, DirCache dc, ObjectId mergeCommitTree, WorkingTreeIterator workingTree) throws IOException {
        this.repo = repo;
        this.dc = dc;
        this.headCommitTree = headCommitTree;
        this.mergeCommitTree = mergeCommitTree;
        this.workingTree = workingTree;
    }

    public DirCacheCheckout(Repository repo, ObjectId headCommitTree, DirCache dc, ObjectId mergeCommitTree) throws IOException {
        this(repo, headCommitTree, dc, mergeCommitTree, new FileTreeIterator(repo));
    }

    public DirCacheCheckout(Repository repo, DirCache dc, ObjectId mergeCommitTree, WorkingTreeIterator workingTree) throws IOException {
        this(repo, null, dc, mergeCommitTree, workingTree);
    }

    public DirCacheCheckout(Repository repo, DirCache dc, ObjectId mergeCommitTree) throws IOException {
        this(repo, null, dc, mergeCommitTree, new FileTreeIterator(repo));
    }

    public void preScanTwoTrees() throws CorruptObjectException, IOException {
        this.removed.clear();
        this.updated.clear();
        this.conflicts.clear();
        this.walk = new NameConflictTreeWalk(this.repo);
        this.builder = this.dc.builder();
        this.addTree(this.walk, this.headCommitTree);
        this.addTree(this.walk, this.mergeCommitTree);
        this.walk.addTree(new DirCacheBuildIterator(this.builder));
        this.walk.addTree(this.workingTree);
        while (this.walk.next()) {
            this.processEntry(this.walk.getTree(0, CanonicalTreeParser.class), this.walk.getTree(1, CanonicalTreeParser.class), this.walk.getTree(2, DirCacheBuildIterator.class), this.walk.getTree(3, WorkingTreeIterator.class));
            if (!this.walk.isSubtree()) continue;
            this.walk.enterSubtree();
        }
    }

    private void addTree(TreeWalk tw, ObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        if (id == null) {
            tw.addTree(new EmptyTreeIterator());
        } else {
            tw.addTree(id);
        }
    }

    public void prescanOneTree() throws MissingObjectException, IncorrectObjectTypeException, CorruptObjectException, IOException {
        this.removed.clear();
        this.updated.clear();
        this.conflicts.clear();
        this.builder = this.dc.builder();
        this.walk = new NameConflictTreeWalk(this.repo);
        this.addTree(this.walk, this.mergeCommitTree);
        this.walk.addTree(new DirCacheBuildIterator(this.builder));
        this.walk.addTree(this.workingTree);
        while (this.walk.next()) {
            this.processEntry(this.walk.getTree(0, CanonicalTreeParser.class), this.walk.getTree(1, DirCacheBuildIterator.class), this.walk.getTree(2, WorkingTreeIterator.class));
            if (!this.walk.isSubtree()) continue;
            this.walk.enterSubtree();
        }
        this.conflicts.removeAll(this.removed);
    }

    void processEntry(CanonicalTreeParser m, DirCacheBuildIterator i, WorkingTreeIterator f) throws IOException {
        if (m != null) {
            DirCacheCheckout.checkValidPath(m);
            if (i == null) {
                if (f != null && !FileMode.TREE.equals(f.getEntryFileMode()) && !f.isEntryIgnored()) {
                    this.conflicts.add(this.walk.getPathString());
                } else {
                    this.update(m.getEntryPathString(), m.getEntryObjectId(), m.getEntryFileMode());
                }
            } else if (f == null || !m.idEqual(i)) {
                this.update(m.getEntryPathString(), m.getEntryObjectId(), m.getEntryFileMode());
            } else if (i.getDirCacheEntry() != null) {
                if (f.isModified(i.getDirCacheEntry(), true, this.walk.getObjectReader()) || i.getDirCacheEntry().getStage() != 0) {
                    this.update(m.getEntryPathString(), m.getEntryObjectId(), m.getEntryFileMode());
                } else {
                    DirCacheEntry entry = i.getDirCacheEntry();
                    if (entry.getLastModified() == 0L) {
                        entry.setLastModified(f.getEntryLastModified());
                    }
                    this.keep(entry);
                }
            } else {
                this.keep(i.getDirCacheEntry());
            }
        } else if (f != null) {
            if (this.walk.isDirectoryFileConflict()) {
                this.conflicts.add(this.walk.getPathString());
            } else if (i != null) {
                this.remove(i.getEntryPathString());
                this.conflicts.remove(i.getEntryPathString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkout() throws IOException {
        try {
            boolean bl = this.doCheckout();
            return bl;
        }
        finally {
            this.dc.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCheckout() throws CorruptObjectException, IOException, MissingObjectException, IncorrectObjectTypeException, CheckoutConflictException, IndexWriteException {
        this.toBeDeleted.clear();
        ObjectReader objectReader = this.repo.getObjectDatabase().newReader();
        try {
            if (this.headCommitTree != null) {
                this.preScanTwoTrees();
            } else {
                this.prescanOneTree();
            }
            if (!this.conflicts.isEmpty()) {
                if (this.failOnConflict) {
                    throw new CheckoutConflictException(this.conflicts.toArray(new String[this.conflicts.size()]));
                }
                this.cleanUpConflicts();
            }
            this.builder.finish();
            File file = null;
            String last = null;
            for (int i = this.removed.size() - 1; i >= 0; --i) {
                String r = this.removed.get(i);
                file = new File(this.repo.getWorkTree(), r);
                if (!file.delete() && this.repo.getFS().exists(file)) {
                    if (this.repo.getFS().isDirectory(file)) continue;
                    this.toBeDeleted.add(r);
                    continue;
                }
                if (last != null && !DirCacheCheckout.isSamePrefix(r, last)) {
                    this.removeEmptyParents(new File(this.repo.getWorkTree(), last));
                }
                last = r;
            }
            if (file != null) {
                this.removeEmptyParents(file);
            }
            for (String path : this.updated.keySet()) {
                DirCacheEntry entry;
                file = new File(this.repo.getWorkTree(), path);
                if (!file.getParentFile().mkdirs()) {
                    // empty if block
                }
                if (FileMode.GITLINK.equals((entry = this.dc.getEntry(path)).getRawMode())) continue;
                DirCacheCheckout.checkoutEntry(this.repo, file, entry, objectReader);
            }
            if (!this.builder.commit()) {
                throw new IndexWriteException();
            }
        }
        finally {
            objectReader.release();
        }
        return this.toBeDeleted.size() == 0;
    }

    private static boolean isSamePrefix(String a, String b) {
        int as = a.lastIndexOf(47);
        int bs = b.lastIndexOf(47);
        return a.substring(0, as + 1).equals(b.substring(0, bs + 1));
    }

    private void removeEmptyParents(File f) {
        for (File parentFile = f.getParentFile(); parentFile != null && !parentFile.equals(this.repo.getWorkTree()) && parentFile.delete(); parentFile = parentFile.getParentFile()) {
        }
    }

    private boolean equalIdAndMode(ObjectId id1, FileMode mode1, ObjectId id2, FileMode mode2) {
        if (!mode1.equals(mode2)) {
            return false;
        }
        return id1 != null ? id1.equals(id2) : id2 == null;
    }

    void processEntry(CanonicalTreeParser h, CanonicalTreeParser m, DirCacheBuildIterator i, WorkingTreeIterator f) throws IOException {
        DirCacheEntry dce = i != null ? i.getDirCacheEntry() : null;
        String name = this.walk.getPathString();
        if (m != null) {
            DirCacheCheckout.checkValidPath(m);
        }
        if (i == null && m == null && h == null) {
            if (this.walk.isDirectoryFileConflict()) {
                this.conflict(name, null, null, null);
            }
            return;
        }
        ObjectId iId = i == null ? null : i.getEntryObjectId();
        ObjectId mId = m == null ? null : m.getEntryObjectId();
        ObjectId hId = h == null ? null : h.getEntryObjectId();
        FileMode iMode = i == null ? null : i.getEntryFileMode();
        FileMode mMode = m == null ? null : m.getEntryFileMode();
        FileMode hMode = h == null ? null : h.getEntryFileMode();
        int ffMask = 0;
        if (h != null) {
            int n = ffMask = FileMode.TREE.equals(hMode) ? 3328 : 3840;
        }
        if (i != null) {
            ffMask |= FileMode.TREE.equals(iMode) ? 208 : 240;
        }
        if (m != null) {
            ffMask |= FileMode.TREE.equals(mMode) ? 13 : 15;
        }
        if ((ffMask & 0x222) != 0 && ((ffMask & 0xF) == 13 || (ffMask & 0xF0) == 208 || (ffMask & 0xF00) == 3328)) {
            switch (ffMask) {
                case 3551: {
                    if (this.isModified(name)) {
                        this.conflict(name, dce, h, m);
                        break;
                    }
                    this.update(name, mId, mMode);
                    break;
                }
                case 3581: {
                    this.keep(dce);
                    break;
                }
                case 3853: {
                    this.remove(name);
                    break;
                }
                case 3583: {
                    if (this.equalIdAndMode(iId, iMode, mId, mMode)) {
                        this.keep(dce);
                        break;
                    }
                    this.conflict(name, dce, h, m);
                    break;
                }
                case 4061: {
                    break;
                }
                case 3343: {
                    this.update(name, mId, mMode);
                    break;
                }
                case 253: 
                case 3568: {
                    this.conflict(name, dce, h, m);
                    break;
                }
                case 4063: {
                    if (this.equalIdAndMode(hId, hMode, mId, mMode)) {
                        if (this.isModified(name)) {
                            this.conflict(name, dce, h, m);
                            break;
                        }
                        this.update(name, mId, mMode);
                        break;
                    }
                    if (!this.isModified(name)) {
                        this.update(name, mId, mMode);
                        break;
                    }
                    this.conflict(name, dce, h, m);
                    break;
                }
                case 4048: {
                    this.keep(dce);
                    break;
                }
                case 4093: {
                    if (this.equalIdAndMode(hId, hMode, iId, iMode)) {
                        if (f == null || f.isModified(dce, true, this.walk.getObjectReader())) {
                            this.conflict(name, dce, h, m);
                            break;
                        }
                        this.remove(name);
                        break;
                    }
                    this.conflict(name, dce, h, m);
                    break;
                }
                case 223: {
                    if (!this.isModified(name)) {
                        this.update(name, mId, mMode);
                        break;
                    }
                    this.conflict(name, dce, h, m);
                    break;
                }
                default: {
                    this.keep(dce);
                }
            }
            return;
        }
        if ((ffMask & 0x222) == 0) {
            return;
        }
        if (ffMask == 15 && f != null && FileMode.TREE.equals(f.getEntryFileMode())) {
            this.conflict(name, null, h, m);
        }
        if (i == null) {
            if (!(f == null || FileMode.GITLINK.equals(mMode) || mId != null && this.equalIdAndMode(mId, mMode, f.getEntryObjectId(), f.getEntryFileMode()))) {
                this.conflict(name, null, h, m);
                return;
            }
            if (h == null) {
                this.update(name, mId, mMode);
            } else if (m == null) {
                this.remove(name);
            } else if (this.equalIdAndMode(hId, hMode, mId, mMode)) {
                this.keep(dce);
            } else {
                this.conflict(name, dce, h, m);
            }
        } else if (h == null) {
            if (m == null || this.equalIdAndMode(mId, mMode, iId, iMode)) {
                if (m == null && this.walk.isDirectoryFileConflict()) {
                    if (dce != null && (f == null || f.isModified(dce, true, this.walk.getObjectReader()))) {
                        this.conflict(name, dce, h, m);
                    } else {
                        this.remove(name);
                    }
                } else {
                    this.keep(dce);
                }
            } else {
                this.conflict(name, dce, h, m);
            }
        } else if (m == null) {
            if (iMode == FileMode.GITLINK) {
                this.remove(name);
            } else if (this.equalIdAndMode(hId, hMode, iId, iMode)) {
                if (f == null || f.isModified(dce, true, this.walk.getObjectReader())) {
                    this.conflict(name, dce, h, m);
                } else {
                    this.remove(name);
                }
            } else {
                this.conflict(name, dce, h, m);
            }
        } else if (!(this.equalIdAndMode(hId, hMode, mId, mMode) || this.equalIdAndMode(hId, hMode, iId, iMode) || this.equalIdAndMode(mId, mMode, iId, iMode))) {
            this.conflict(name, dce, h, m);
        } else if (this.equalIdAndMode(hId, hMode, iId, iMode) && !this.equalIdAndMode(mId, mMode, iId, iMode)) {
            if (dce != null && FileMode.GITLINK.equals(dce.getFileMode())) {
                this.update(name, mId, mMode);
            } else if (dce != null && f != null && f.isModified(dce, true, this.walk.getObjectReader())) {
                this.conflict(name, dce, h, m);
            } else {
                this.update(name, mId, mMode);
            }
        } else {
            this.keep(dce);
        }
    }

    private void conflict(String path, DirCacheEntry e, AbstractTreeIterator h, AbstractTreeIterator m) {
        DirCacheEntry entry;
        this.conflicts.add(path);
        if (e != null) {
            entry = new DirCacheEntry(e.getPathString(), 1);
            entry.copyMetaData(e, true);
            this.builder.add(entry);
        }
        if (h != null && !FileMode.TREE.equals(h.getEntryFileMode())) {
            entry = new DirCacheEntry(h.getEntryPathString(), 2);
            entry.setFileMode(h.getEntryFileMode());
            entry.setObjectId(h.getEntryObjectId());
            this.builder.add(entry);
        }
        if (m != null && !FileMode.TREE.equals(m.getEntryFileMode())) {
            entry = new DirCacheEntry(m.getEntryPathString(), 3);
            entry.setFileMode(m.getEntryFileMode());
            entry.setObjectId(m.getEntryObjectId());
            this.builder.add(entry);
        }
    }

    private void keep(DirCacheEntry e) {
        if (e != null && !FileMode.TREE.equals(e.getFileMode())) {
            this.builder.add(e);
        }
    }

    private void remove(String path) {
        this.removed.add(path);
    }

    private void update(String path, ObjectId mId, FileMode mode) {
        if (!FileMode.TREE.equals(mode)) {
            this.updated.put(path, mId);
            DirCacheEntry entry = new DirCacheEntry(path, 0);
            entry.setObjectId(mId);
            entry.setFileMode(mode);
            this.builder.add(entry);
        }
    }

    public void setFailOnConflict(boolean failOnConflict) {
        this.failOnConflict = failOnConflict;
    }

    private void cleanUpConflicts() throws CheckoutConflictException {
        for (String c : this.conflicts) {
            File conflict = new File(this.repo.getWorkTree(), c);
            if (!conflict.delete()) {
                throw new CheckoutConflictException(MessageFormat.format(JGitText.get().cannotDeleteFile, c));
            }
            this.removeEmptyParents(conflict);
        }
        for (String r : this.removed) {
            File file = new File(this.repo.getWorkTree(), r);
            if (!file.delete()) {
                throw new CheckoutConflictException(MessageFormat.format(JGitText.get().cannotDeleteFile, file.getAbsolutePath()));
            }
            this.removeEmptyParents(file);
        }
    }

    private boolean isModified(String path) throws CorruptObjectException, IOException {
        NameConflictTreeWalk tw = new NameConflictTreeWalk(this.repo);
        tw.addTree(new DirCacheIterator(this.dc));
        tw.addTree(new FileTreeIterator(this.repo));
        tw.setRecursive(true);
        tw.setFilter(PathFilter.create(path));
        while (tw.next()) {
            DirCacheIterator dcIt = tw.getTree(0, DirCacheIterator.class);
            WorkingTreeIterator wtIt = tw.getTree(1, WorkingTreeIterator.class);
            if (dcIt == null || wtIt == null) {
                return true;
            }
            if (!wtIt.isModified(dcIt.getDirCacheEntry(), true, this.walk.getObjectReader())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkoutEntry(Repository repository, File f, DirCacheEntry entry) throws IOException {
        ObjectReader or = repository.newObjectReader();
        try {
            DirCacheCheckout.checkoutEntry(repository, f, entry, repository.newObjectReader());
        }
        finally {
            or.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkoutEntry(Repository repo, File f, DirCacheEntry entry, ObjectReader or) throws IOException {
        ObjectLoader ol = or.open(entry.getObjectId());
        File parentDir = f.getParentFile();
        parentDir.mkdirs();
        FS fs = repo.getFS();
        WorkingTreeOptions opt = repo.getConfig().get(WorkingTreeOptions.KEY);
        if (entry.getFileMode() == FileMode.SYMLINK && opt.getSymLinks() == CoreConfig.SymLinks.TRUE) {
            byte[] bytes = ol.getBytes();
            String target = RawParseUtils.decode(bytes);
            fs.createSymLink(f, target);
            entry.setLength(bytes.length);
            entry.setLastModified(fs.lastModified(f));
        } else {
            File tmpFile = File.createTempFile("._" + f.getName(), null, parentDir);
            FileOutputStream rawChannel = new FileOutputStream(tmpFile);
            OutputStream channel = opt.getAutoCRLF() == CoreConfig.AutoCRLF.TRUE ? new AutoCRLFOutputStream(rawChannel) : rawChannel;
            try {
                ol.copyTo(channel);
            }
            finally {
                channel.close();
            }
            if (opt.isFileMode() && fs.supportsExecute()) {
                if (FileMode.EXECUTABLE_FILE.equals(entry.getRawMode())) {
                    if (!fs.canExecute(tmpFile)) {
                        fs.setExecute(tmpFile, true);
                    }
                } else if (fs.canExecute(tmpFile)) {
                    fs.setExecute(tmpFile, false);
                }
            }
            try {
                FileUtils.rename(tmpFile, f);
            }
            catch (IOException e) {
                throw new IOException(MessageFormat.format(JGitText.get().couldNotWriteFile, tmpFile.getPath(), f.getPath()));
            }
        }
        entry.setLastModified(f.lastModified());
        if (opt.getAutoCRLF() != CoreConfig.AutoCRLF.FALSE) {
            entry.setLength(f.length());
        } else {
            entry.setLength((int)ol.getSize());
        }
    }

    private static void checkValidPath(CanonicalTreeParser t) throws InvalidPathException {
        ObjectChecker chk = new ObjectChecker().setSafeForWindows(SystemReader.getInstance().isWindows()).setSafeForMacOS(SystemReader.getInstance().isMacOS());
        for (CanonicalTreeParser i = t; i != null; i = i.getParent()) {
            DirCacheCheckout.checkValidPathSegment(chk, i);
        }
    }

    public static void checkValidPath(String path) throws InvalidPathException {
        ObjectChecker chk = new ObjectChecker().setSafeForWindows(SystemReader.getInstance().isWindows()).setSafeForMacOS(SystemReader.getInstance().isMacOS());
        byte[] bytes = Constants.encode(path);
        int segmentStart = 0;
        try {
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 47) continue;
                chk.checkPathSegment(bytes, segmentStart, i);
                segmentStart = i + 1;
            }
            chk.checkPathSegment(bytes, segmentStart, bytes.length);
        }
        catch (CorruptObjectException e) {
            throw new InvalidPathException(e.getMessage());
        }
    }

    private static void checkValidPathSegment(ObjectChecker chk, CanonicalTreeParser t) throws InvalidPathException {
        try {
            int ptr = t.getNameOffset();
            int end = ptr + t.getNameLength();
            chk.checkPathSegment(t.getEntryPathBuffer(), ptr, end);
        }
        catch (CorruptObjectException err) {
            String path = t.getEntryPathString();
            InvalidPathException i = new InvalidPathException(path);
            i.initCause(err);
            throw i;
        }
    }
}

