/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.Enumeration;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.http.server.HttpServerText;
import org.eclipse.jgit.lib.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileSender {
    private final File path;
    private final RandomAccessFile source;
    private final long lastModified;
    private final long fileLen;
    private long pos;
    private long end;

    FileSender(File path) throws FileNotFoundException {
        this.path = path;
        this.source = new RandomAccessFile(path, "r");
        try {
            this.lastModified = path.lastModified();
            this.end = this.fileLen = this.source.getChannel().size();
        }
        catch (IOException e) {
            try {
                this.source.close();
            }
            catch (IOException closeError) {
                // empty catch block
            }
            FileNotFoundException r = new FileNotFoundException(MessageFormat.format(HttpServerText.get().cannotGetLengthOf, path));
            r.initCause(e);
            throw r;
        }
    }

    void close() {
        try {
            this.source.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    long getLastModified() {
        return this.lastModified;
    }

    String getTailChecksum() throws IOException {
        int n = 20;
        byte[] buf = new byte[20];
        this.source.seek(this.fileLen - 20L);
        this.source.readFully(buf, 0, 20);
        return ObjectId.fromRaw(buf).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serve(HttpServletRequest req, HttpServletResponse rsp, boolean sendBody) throws IOException {
        if (!this.initRangeRequest(req, rsp)) {
            rsp.sendError(416);
            return;
        }
        rsp.setHeader("Accept-Ranges", "bytes");
        rsp.setHeader("Content-Length", Long.toString(this.end - this.pos));
        if (sendBody) {
            ServletOutputStream out = rsp.getOutputStream();
            try {
                byte[] buf = new byte[4096];
                this.source.seek(this.pos);
                while (this.pos < this.end) {
                    int r = (int)Math.min((long)buf.length, this.end - this.pos);
                    int n = this.source.read(buf, 0, r);
                    if (n < 0) {
                        throw new EOFException(MessageFormat.format(HttpServerText.get().unexpectedeOFOn, this.path));
                    }
                    out.write(buf, 0, n);
                    this.pos += (long)n;
                }
                out.flush();
            }
            finally {
                out.close();
            }
        }
    }

    private boolean initRangeRequest(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        Enumeration<String> rangeHeaders = FileSender.getRange(req);
        if (!rangeHeaders.hasMoreElements()) {
            return true;
        }
        String range = rangeHeaders.nextElement();
        if (rangeHeaders.hasMoreElements()) {
            return false;
        }
        int eq = range.indexOf(61);
        int dash = range.indexOf(45);
        if (eq < 0 || dash < 0 || !range.startsWith("bytes=")) {
            return false;
        }
        String ifRange = req.getHeader("If-Range");
        if (ifRange != null && !this.getTailChecksum().equals(ifRange)) {
            return true;
        }
        try {
            if (eq + 1 == dash) {
                this.pos = Long.parseLong(range.substring(dash + 1));
                this.pos = this.fileLen - this.pos;
            } else {
                this.pos = Long.parseLong(range.substring(eq + 1, dash));
                if (dash < range.length() - 1) {
                    this.end = Long.parseLong(range.substring(dash + 1));
                    ++this.end;
                }
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (this.end > this.fileLen) {
            this.end = this.fileLen;
        }
        if (this.pos >= this.end) {
            return false;
        }
        rsp.setStatus(206);
        rsp.setHeader("Content-Range", "bytes " + this.pos + "-" + (this.end - 1L) + "/" + this.fileLen);
        this.source.seek(this.pos);
        return true;
    }

    private static Enumeration<String> getRange(HttpServletRequest req) {
        return req.getHeaders("Range");
    }
}

