/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.hibernate.memcached;

import com.googlecode.hibernate.memcached.KeyStrategy;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKeyStrategy
implements KeyStrategy {
    public static final int MAX_KEY_LENGTH = 250;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Pattern CLEAN_PATTERN = Pattern.compile("\\s");

    public String toKey(String regionName, long clearIndex, Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        String keyString = this.concatenateKey(regionName, clearIndex, this.transformKeyObject(key));
        if (keyString.length() > 250) {
            throw new IllegalArgumentException("Key is longer than 250 characters, try using the Sha1KeyStrategy: " + keyString);
        }
        String finalKey = CLEAN_PATTERN.matcher(keyString).replaceAll("");
        this.log.debug("Final cache key: [{}]", (Object)finalKey);
        return finalKey;
    }

    protected abstract String transformKeyObject(Object var1);

    protected String concatenateKey(String regionName, long clearIndex, Object key) {
        return regionName + ":" + clearIndex + ":" + String.valueOf(key);
    }
}

