/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.hibernate.memcached;

import com.googlecode.hibernate.memcached.Config;
import com.googlecode.hibernate.memcached.KeyStrategy;
import com.googlecode.hibernate.memcached.Memcache;
import com.googlecode.hibernate.memcached.MemcacheClientFactory;
import com.googlecode.hibernate.memcached.MemcachedCache;
import com.googlecode.hibernate.memcached.PropertiesHelper;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcachedCacheProvider
implements CacheProvider {
    private final Logger log = LoggerFactory.getLogger(MemcachedCacheProvider.class);
    private Memcache client;

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        Config config = new Config(new PropertiesHelper(properties));
        this.log.info("Building cache for region [{}]", (Object)regionName);
        MemcachedCache cache = new MemcachedCache(regionName, this.client);
        String keyStrategy = config.getKeyStrategyName(regionName);
        if (keyStrategy != null) {
            this.setKeyStrategy(keyStrategy, cache);
        }
        cache.setCacheTimeSeconds(config.getCacheTimeSeconds(regionName));
        cache.setClearSupported(config.isClearSupported(regionName));
        boolean dogpilePrevention = config.isDogpilePreventionEnabled(regionName);
        cache.setDogpilePreventionEnabled(dogpilePrevention);
        if (dogpilePrevention) {
            cache.setDogpilePreventionExpirationFactor(config.getDogpilePreventionExpirationFactor(regionName));
        }
        return cache;
    }

    private void setKeyStrategy(String keyStrategyName, MemcachedCache cache) {
        this.log.debug("Using KeyStrategy: [{}]", (Object)keyStrategyName);
        KeyStrategy keyStrategy = this.instantiateKeyStrategy(keyStrategyName);
        cache.setKeyStrategy(keyStrategy);
    }

    protected KeyStrategy instantiateKeyStrategy(String cls) {
        try {
            return (KeyStrategy)Class.forName(cls).newInstance();
        }
        catch (InstantiationException e) {
            throw new CacheException("Could not instantiate keyStrategy class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CacheException("Could not instantiate keyStrategy class", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException("Could not instantiate keyStrategy class", (Throwable)e);
        }
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public void start(Properties properties) throws CacheException {
        this.log.info("Starting MemcachedClient...");
        try {
            this.client = this.getMemcachedClientFactory(new Config(new PropertiesHelper(properties))).createMemcacheClient();
        }
        catch (Exception e) {
            throw new CacheException("Unable to initialize MemcachedClient", (Throwable)e);
        }
    }

    protected MemcacheClientFactory getMemcachedClientFactory(Config config) {
        MemcacheClientFactory clientFactory;
        Constructor<?> constructor;
        String factoryClassName = config.getMemcachedClientFactoryName();
        try {
            constructor = Class.forName(factoryClassName).getConstructor(PropertiesHelper.class);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException("Unable to find factory class [" + factoryClassName + "]", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new CacheException("Unable to find PropertiesHelper constructor for factory class [" + factoryClassName + "]", (Throwable)e);
        }
        try {
            clientFactory = (MemcacheClientFactory)constructor.newInstance(config.getPropertiesHelper());
        }
        catch (Exception e) {
            throw new CacheException("Unable to instantiate factory class [" + factoryClassName + "]", (Throwable)e);
        }
        return clientFactory;
    }

    public void stop() {
        if (this.client != null) {
            this.log.debug("Shutting down Memcache client");
            this.client.shutdown();
        }
        this.client = null;
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }
}

