/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.hibernate.memcached;

import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesHelper {
    private Properties properties;

    public PropertiesHelper(Properties properties) {
        this.properties = properties;
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public String get(String key, String defaultVal) {
        String val = this.get(key);
        return val == null ? defaultVal : val;
    }

    public String findValue(String ... keys) {
        for (String key : keys) {
            String value = this.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public boolean getBoolean(String key, boolean defaultVal) {
        String val = this.get(key);
        return val == null ? defaultVal : Boolean.parseBoolean(val);
    }

    public long getLong(String key, long defaultVal) {
        String val = this.get(key);
        return val == null ? defaultVal : Long.parseLong(val);
    }

    public int getInt(String key, int defaultVal) {
        return (int)this.getLong(key, defaultVal);
    }

    public double getDouble(String key, double defaultVal) {
        String val = this.get(key);
        return val == null ? defaultVal : Double.parseDouble(val);
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> type, T defaultValue) {
        String val = this.get(key);
        return val == null ? defaultValue : Enum.valueOf(type, val);
    }
}

