/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.hibernate.memcached.spymemcached;

import com.googlecode.hibernate.memcached.Memcache;
import com.googlecode.hibernate.memcached.MemcacheClientFactory;
import com.googlecode.hibernate.memcached.PropertiesHelper;
import com.googlecode.hibernate.memcached.spymemcached.SpyMemcache;
import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.KetamaConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpyMemcacheClientFactory
implements MemcacheClientFactory {
    public static final String PROP_SERVERS = "hibernate.memcached.servers";
    public static final String PROP_OPERATION_QUEUE_LENGTH = "hibernate.memcached.operationQueueLength";
    public static final String PROP_READ_BUFFER_SIZE = "hibernate.memcached.readBufferSize";
    public static final String PROP_OPERATION_TIMEOUT = "hibernate.memcached.operationTimeout";
    public static final String PROP_HASH_ALGORITHM = "hibernate.memcached.hashAlgorithm";
    public static final String PROP_CONNECTION_FACTORY = "hibernate.memcached.connectionFactory";
    public static final String PROP_DAEMON_MODE = "hibernate.memcached.daemonMode";
    public static final String PROP_USERNAME = "hibernate.memcached.username";
    public static final String PROP_PASSWORD = "hibernate.memcached.password";
    private final PropertiesHelper properties;

    public SpyMemcacheClientFactory(PropertiesHelper properties) {
        this.properties = properties;
    }

    @Override
    public Memcache createMemcacheClient() throws Exception {
        ConnectionFactory connectionFactory = this.getConnectionFactory();
        MemcachedClient client = new MemcachedClient(connectionFactory, AddrUtil.getAddresses((String)this.getServerList()));
        return new SpyMemcache(client);
    }

    protected ConnectionFactory getConnectionFactory() {
        if (this.connectionFactoryNameEquals(DefaultConnectionFactory.class)) {
            return this.buildDefaultConnectionFactory();
        }
        if (this.connectionFactoryNameEquals(KetamaConnectionFactory.class)) {
            return this.buildKetamaConnectionFactory();
        }
        if (this.connectionFactoryNameEquals(BinaryConnectionFactory.class)) {
            return this.buildBinaryConnectionFactory();
        }
        throw new IllegalArgumentException("Unsupported hibernate.memcached.connectionFactory value: " + this.getConnectionFactoryName());
    }

    private boolean connectionFactoryNameEquals(Class<?> cls) {
        return cls.getSimpleName().equals(this.getConnectionFactoryName());
    }

    private DefaultConnectionFactory buildDefaultConnectionFactory() {
        return new DefaultConnectionFactory(this.getOperationQueueLength(), this.getReadBufferSize(), this.getHashAlgorithm()){

            public long getOperationTimeout() {
                return SpyMemcacheClientFactory.this.getOperationTimeoutMillis();
            }

            public boolean isDaemon() {
                return SpyMemcacheClientFactory.this.isDaemonMode();
            }

            public AuthDescriptor getAuthDescriptor() {
                return SpyMemcacheClientFactory.this.createAuthDescriptor();
            }
        };
    }

    private KetamaConnectionFactory buildKetamaConnectionFactory() {
        return new KetamaConnectionFactory(){

            public long getOperationTimeout() {
                return SpyMemcacheClientFactory.this.getOperationTimeoutMillis();
            }

            public boolean isDaemon() {
                return SpyMemcacheClientFactory.this.isDaemonMode();
            }

            public AuthDescriptor getAuthDescriptor() {
                return SpyMemcacheClientFactory.this.createAuthDescriptor();
            }
        };
    }

    private BinaryConnectionFactory buildBinaryConnectionFactory() {
        return new BinaryConnectionFactory(this.getOperationQueueLength(), this.getReadBufferSize(), this.getHashAlgorithm()){

            public long getOperationTimeout() {
                return SpyMemcacheClientFactory.this.getOperationTimeoutMillis();
            }

            public boolean isDaemon() {
                return SpyMemcacheClientFactory.this.isDaemonMode();
            }

            public AuthDescriptor getAuthDescriptor() {
                return SpyMemcacheClientFactory.this.createAuthDescriptor();
            }
        };
    }

    protected AuthDescriptor createAuthDescriptor() {
        String username = this.properties.get(PROP_USERNAME);
        String password = this.properties.get(PROP_PASSWORD);
        if (username == null || password == null) {
            return null;
        }
        return new AuthDescriptor(new String[]{"PLAIN"}, (CallbackHandler)new PlainCallbackHandler(username, password));
    }

    public String getServerList() {
        return this.properties.get(PROP_SERVERS, "localhost:11211");
    }

    public int getOperationQueueLength() {
        return this.properties.getInt(PROP_OPERATION_QUEUE_LENGTH, 16384);
    }

    public int getReadBufferSize() {
        return this.properties.getInt(PROP_READ_BUFFER_SIZE, 16384);
    }

    public long getOperationTimeoutMillis() {
        return this.properties.getLong(PROP_OPERATION_TIMEOUT, 2500L);
    }

    public boolean isDaemonMode() {
        return this.properties.getBoolean(PROP_DAEMON_MODE, false);
    }

    public HashAlgorithm getHashAlgorithm() {
        return this.properties.getEnum(PROP_HASH_ALGORITHM, HashAlgorithm.class, HashAlgorithm.NATIVE_HASH);
    }

    public String getConnectionFactoryName() {
        return this.properties.get(PROP_CONNECTION_FACTORY, DefaultConnectionFactory.class.getSimpleName());
    }

    protected PropertiesHelper getProperties() {
        return this.properties;
    }
}

