/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientRegressionWithMockNetworkTest;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.operation.MergeOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.listener.EntryMergedListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.map.merge.PassThroughMergePolicy;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientListenersTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    HazelcastInstance client;
    HazelcastInstance server;

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        ClientConfig config = new ClientConfig();
        config.getSerializationConfig().addPortableFactory(5, new PortableFactory(){

            public Portable create(int classId) {
                if (classId == 6) {
                    return new ClientRegressionWithMockNetworkTest.SamplePortable();
                }
                return null;
            }
        });
        config.addListenerConfig(new ListenerConfig("com.hazelcast.client.ClientListenersTest$StaticListener"));
        this.server = this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient(config);
    }

    @Test
    public void testEntryListener_withPortableNotRegisteredInNode() throws Exception {
        IMap map = this.client.getMap(ClientListenersTest.randomMapName());
        final CountDownLatch latch = new CountDownLatch(1);
        map.addEntryListener((EntryListener)new EntryAdapter<Object, Object>(){

            public void entryAdded(EntryEvent<Object, Object> event) {
                latch.countDown();
            }
        }, true);
        map.put((Object)1, (Object)new ClientRegressionWithMockNetworkTest.SamplePortable(1));
        ClientListenersTest.assertOpenEventually((CountDownLatch)latch);
    }

    @Test
    public void testEntryMergeListener_withPortableNotRegisteredInNode() throws Exception {
        IMap map = this.client.getMap(ClientListenersTest.randomMapName());
        final CountDownLatch latch = new CountDownLatch(1);
        map.addEntryListener((MapListener)new EntryMergedListener<Object, Object>(){

            public void entryMerged(EntryEvent<Object, Object> event) {
                latch.countDown();
            }
        }, true);
        Node node = ClientListenersTest.getNode((HazelcastInstance)this.server);
        NodeEngineImpl nodeEngine = node.nodeEngine;
        OperationServiceImpl operationService = (OperationServiceImpl)nodeEngine.getOperationService();
        InternalSerializationService serializationService = ClientListenersTest.getSerializationService((HazelcastInstance)this.server);
        Data key = serializationService.toData((Object)1);
        Data value = serializationService.toData((Object)new ClientRegressionWithMockNetworkTest.SamplePortable(1));
        EntryView entryView = EntryViews.createSimpleEntryView((Object)key, (Object)value, (Record)((Record)Mockito.mock(Record.class)));
        MergeOperation op = new MergeOperation(map.getName(), key, entryView, (MapMergePolicy)new PassThroughMergePolicy());
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        operationService.invokeOnPartition("hz:impl:mapService", (Operation)op, partitionId);
        ClientListenersTest.assertOpenEventually((CountDownLatch)latch);
    }

    @Test
    public void testItemListener_withPortableNotRegisteredInNode() throws Exception {
        IQueue queue = this.client.getQueue(ClientListenersTest.randomMapName());
        final CountDownLatch latch = new CountDownLatch(1);
        queue.addItemListener((ItemListener)new ItemListener<Object>(){

            public void itemAdded(ItemEvent<Object> item) {
                latch.countDown();
            }

            public void itemRemoved(ItemEvent<Object> item) {
            }
        }, true);
        queue.offer((Object)new ClientRegressionWithMockNetworkTest.SamplePortable(1));
        ClientListenersTest.assertOpenEventually((CountDownLatch)latch);
    }

    @Test
    public void testSetListener_withPortableNotRegisteredInNode() throws Exception {
        ISet set = this.client.getSet(ClientListenersTest.randomMapName());
        final CountDownLatch latch = new CountDownLatch(1);
        set.addItemListener((ItemListener)new ItemListener<Object>(){

            public void itemAdded(ItemEvent<Object> item) {
                latch.countDown();
            }

            public void itemRemoved(ItemEvent<Object> item) {
            }
        }, true);
        set.add((Object)new ClientRegressionWithMockNetworkTest.SamplePortable(1));
        ClientListenersTest.assertOpenEventually((CountDownLatch)latch);
    }

    @Test
    public void testListListener_withPortableNotRegisteredInNode() throws Exception {
        IList list = this.client.getList(ClientListenersTest.randomMapName());
        final CountDownLatch latch = new CountDownLatch(1);
        list.addItemListener((ItemListener)new ItemListener<Object>(){

            public void itemAdded(ItemEvent<Object> item) {
                latch.countDown();
            }

            public void itemRemoved(ItemEvent<Object> item) {
            }
        }, true);
        list.add((Object)new ClientRegressionWithMockNetworkTest.SamplePortable(1));
        ClientListenersTest.assertOpenEventually((CountDownLatch)latch);
    }

    @Test
    public void testTopic_withPortableNotRegisteredInNode() throws Exception {
        ITopic topic = this.client.getTopic(ClientListenersTest.randomMapName());
        final CountDownLatch latch = new CountDownLatch(1);
        topic.addMessageListener((MessageListener)new MessageListener<Object>(){

            public void onMessage(Message<Object> message) {
                latch.countDown();
            }
        });
        topic.publish((Object)new ClientRegressionWithMockNetworkTest.SamplePortable(1));
        ClientListenersTest.assertOpenEventually((CountDownLatch)latch);
    }

    @Test
    public void testLifecycleListener_registeredViaClassName() {
        Assert.assertTrue((boolean)StaticListener.calledAtLeastOnce);
    }

    public static class StaticListener
    implements LifecycleListener {
        private static volatile boolean calledAtLeastOnce;

        public void stateChanged(LifecycleEvent event) {
            calledAtLeastOnce = true;
        }
    }
}

