/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastOverloadException;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IMap;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMaxAllowedInvocationTest
extends ClientTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(expected=HazelcastOverloadException.class)
    public void testMaxAllowed_withSyncOperation() {
        int MAX_ALLOWED = 10;
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty(ClientProperty.MAX_CONCURRENT_INVOCATIONS.getName(), String.valueOf(MAX_ALLOWED));
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap map = client.getMap(ClientMaxAllowedInvocationTest.randomString());
        IExecutorService executorService = client.getExecutorService(ClientMaxAllowedInvocationTest.randomString());
        for (int i = 0; i < MAX_ALLOWED; ++i) {
            executorService.submit((Callable)new SleepyProcessor(Integer.MAX_VALUE));
        }
        map.get((Object)2);
    }

    @Test(expected=HazelcastOverloadException.class)
    public void testMaxAllowed_withAsyncOperation() {
        int MAX_ALLOWED = 10;
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty(ClientProperty.MAX_CONCURRENT_INVOCATIONS.getName(), String.valueOf(MAX_ALLOWED));
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap map = client.getMap(ClientMaxAllowedInvocationTest.randomString());
        IExecutorService executorService = client.getExecutorService(ClientMaxAllowedInvocationTest.randomString());
        for (int i = 0; i < MAX_ALLOWED; ++i) {
            executorService.submit((Callable)new SleepyProcessor(Integer.MAX_VALUE));
        }
        map.getAsync((Object)1);
    }

    @Test(expected=HazelcastOverloadException.class)
    public void testMaxAllowed_withUnfinishedCallback() throws ExecutionException, InterruptedException {
        int MAX_ALLOWED = 10;
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty(ClientProperty.MAX_CONCURRENT_INVOCATIONS.getName(), String.valueOf(MAX_ALLOWED));
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        String name = ClientMaxAllowedInvocationTest.randomString();
        IMap map = client.getMap(name);
        IExecutorService executorService = client.getExecutorService(ClientMaxAllowedInvocationTest.randomString());
        for (int i = 0; i < MAX_ALLOWED - 1; ++i) {
            executorService.submit((Callable)new SleepyProcessor(Integer.MAX_VALUE));
        }
        ClientDelegatingFuture future = (ClientDelegatingFuture)executorService.submit((Callable)new SleepyProcessor(2000L));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        future.andThenInternal((ExecutionCallback)new SleepyCallback(countDownLatch), false);
        future.get();
        try {
            map.get((Object)1);
        }
        catch (HazelcastOverloadException e) {
            throw e;
        }
        finally {
            countDownLatch.countDown();
        }
    }

    static class SleepyCallback
    implements ExecutionCallback<ClientMessage> {
        final CountDownLatch countDownLatch;

        public SleepyCallback(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        public void onResponse(ClientMessage response) {
            try {
                this.countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void onFailure(Throwable t) {
        }
    }

    static class SleepyProcessor
    implements Callable,
    Serializable {
        private long millis;

        SleepyProcessor(long millis) {
            this.millis = millis;
        }

        public Object call() throws Exception {
            try {
                Thread.sleep(this.millis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return null;
        }
    }
}

