/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.EventListener;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMemberAttributeTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testChangeMemberAttributes() throws Exception {
        int count = 10;
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig config = new ClientConfig();
        ListenerConfig listenerConfig = new ListenerConfig();
        CountDownLatch countDownLatch = new CountDownLatch(10);
        listenerConfig.setImplementation((EventListener)((Object)new LatchMembershipListener(countDownLatch)));
        config.addListenerConfig(listenerConfig);
        this.hazelcastFactory.newHazelcastClient(config);
        Member localMember = instance.getCluster().getLocalMember();
        for (int i = 0; i < 10; ++i) {
            localMember.setStringAttribute("key" + i, HazelcastTestSupport.randomString());
        }
        ClientMemberAttributeTest.assertOpenEventually((CountDownLatch)countDownLatch);
    }

    @Test(timeout=120000L)
    public void testConfigAttributes() throws Exception {
        Config c = new Config();
        JoinConfig join = c.getNetworkConfig().getJoin();
        join.getTcpIpConfig().addMember("127.0.0.1").setEnabled(true);
        join.getMulticastConfig().setEnabled(false);
        MemberAttributeConfig memberAttributeConfig = c.getMemberAttributeConfig();
        memberAttributeConfig.setIntAttribute("Test", 123);
        HazelcastInstance h1 = this.hazelcastFactory.newHazelcastInstance(c);
        Member m1 = h1.getCluster().getLocalMember();
        Assert.assertEquals((long)123L, (long)m1.getIntAttribute("Test").intValue());
        HazelcastInstance h2 = this.hazelcastFactory.newHazelcastInstance(c);
        Member m2 = h2.getCluster().getLocalMember();
        Assert.assertEquals((long)123L, (long)m2.getIntAttribute("Test").intValue());
        Assert.assertEquals((long)2L, (long)h2.getCluster().getMembers().size());
        Member member = null;
        for (Member m : h2.getCluster().getMembers()) {
            if (m == h2.getCluster().getLocalMember()) continue;
            member = m;
        }
        Assert.assertNotNull(member);
        Assert.assertEquals((Object)m1, member);
        Assert.assertNotNull((Object)member.getIntAttribute("Test"));
        Assert.assertEquals((long)123L, (long)member.getIntAttribute("Test").intValue());
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        Set members = client.getCluster().getMembers();
        for (Member m : members) {
            Assert.assertEquals((long)123L, (long)m.getIntAttribute("Test").intValue());
        }
    }

    @Test(timeout=120000L)
    public void testPresharedAttributes() throws Exception {
        Config c = new Config();
        JoinConfig join = c.getNetworkConfig().getJoin();
        join.getTcpIpConfig().addMember("127.0.0.1").setEnabled(true);
        join.getMulticastConfig().setEnabled(false);
        TestHazelcastInstanceFactory factory = this.createHazelcastInstanceFactory(2);
        HazelcastInstance h1 = this.hazelcastFactory.newHazelcastInstance(c);
        Member m1 = h1.getCluster().getLocalMember();
        m1.setIntAttribute("Test", 123);
        HazelcastInstance h2 = this.hazelcastFactory.newHazelcastInstance(c);
        Assert.assertEquals((long)2L, (long)h2.getCluster().getMembers().size());
        Member member = null;
        for (Member m : h2.getCluster().getMembers()) {
            if (m == h2.getCluster().getLocalMember()) continue;
            member = m;
        }
        Assert.assertNotNull(member);
        Assert.assertEquals((Object)m1, member);
        Assert.assertNotNull((Object)member.getIntAttribute("Test"));
        Assert.assertEquals((long)123L, (long)member.getIntAttribute("Test").intValue());
        boolean found = false;
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        Set members = client.getCluster().getMembers();
        for (Member m : members) {
            if (!m.equals(m1)) continue;
            Assert.assertEquals((long)123L, (long)m.getIntAttribute("Test").intValue());
            found = true;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test(timeout=120000L)
    public void testAddAttributes() throws Exception {
        Config c = new Config();
        JoinConfig join = c.getNetworkConfig().getJoin();
        join.getTcpIpConfig().addMember("127.0.0.1").setEnabled(true);
        join.getMulticastConfig().setEnabled(false);
        HazelcastInstance h1 = this.hazelcastFactory.newHazelcastInstance(c);
        Member m1 = h1.getCluster().getLocalMember();
        m1.setIntAttribute("Test", 123);
        HazelcastInstance h2 = this.hazelcastFactory.newHazelcastInstance(c);
        Assert.assertEquals((long)2L, (long)h2.getCluster().getMembers().size());
        Member member = null;
        for (Member m : h2.getCluster().getMembers()) {
            if (m == h2.getCluster().getLocalMember()) continue;
            member = m;
        }
        Assert.assertNotNull(member);
        Assert.assertEquals((Object)m1, member);
        Assert.assertNotNull((Object)member.getIntAttribute("Test"));
        Assert.assertEquals((long)123L, (long)member.getIntAttribute("Test").intValue());
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        CountDownLatch latch = new CountDownLatch(3);
        LatchMembershipListener listener = new LatchMembershipListener(latch);
        h2.getCluster().addMembershipListener((MembershipListener)listener);
        h1.getCluster().addMembershipListener((MembershipListener)listener);
        client.getCluster().addMembershipListener((MembershipListener)listener);
        m1.setIntAttribute("Test2", 321);
        ClientMemberAttributeTest.assertOpenEventually((CountDownLatch)latch);
        Assert.assertNotNull((Object)member.getIntAttribute("Test2"));
        Assert.assertEquals((long)321L, (long)member.getIntAttribute("Test2").intValue());
        boolean found = false;
        Set members = client.getCluster().getMembers();
        for (Member m : members) {
            if (!m.equals(m1)) continue;
            Assert.assertEquals((long)321L, (long)m.getIntAttribute("Test2").intValue());
            found = true;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test(timeout=120000L)
    public void testChangeAttributes() throws Exception {
        Config c = new Config();
        JoinConfig join = c.getNetworkConfig().getJoin();
        join.getTcpIpConfig().addMember("127.0.0.1").setEnabled(true);
        join.getMulticastConfig().setEnabled(false);
        HazelcastInstance h1 = this.hazelcastFactory.newHazelcastInstance(c);
        Member m1 = h1.getCluster().getLocalMember();
        m1.setIntAttribute("Test", 123);
        HazelcastInstance h2 = this.hazelcastFactory.newHazelcastInstance(c);
        Assert.assertEquals((long)2L, (long)h2.getCluster().getMembers().size());
        Member member = null;
        for (Member m : h2.getCluster().getMembers()) {
            if (m == h2.getCluster().getLocalMember()) continue;
            member = m;
        }
        Assert.assertNotNull(member);
        Assert.assertEquals((Object)m1, member);
        Assert.assertNotNull((Object)member.getIntAttribute("Test"));
        Assert.assertEquals((long)123L, (long)member.getIntAttribute("Test").intValue());
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        CountDownLatch latch = new CountDownLatch(3);
        LatchMembershipListener listener = new LatchMembershipListener(latch);
        h2.getCluster().addMembershipListener((MembershipListener)listener);
        h1.getCluster().addMembershipListener((MembershipListener)listener);
        client.getCluster().addMembershipListener((MembershipListener)listener);
        m1.setIntAttribute("Test", 321);
        ClientMemberAttributeTest.assertOpenEventually((CountDownLatch)latch);
        Assert.assertNotNull((Object)member.getIntAttribute("Test"));
        Assert.assertEquals((long)321L, (long)member.getIntAttribute("Test").intValue());
        boolean found = false;
        Set members = client.getCluster().getMembers();
        for (Member m : members) {
            if (!m.equals(m1)) continue;
            Assert.assertEquals((long)321L, (long)m.getIntAttribute("Test").intValue());
            found = true;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test(timeout=120000L)
    public void testRemoveAttributes() throws Exception {
        Config c = new Config();
        JoinConfig join = c.getNetworkConfig().getJoin();
        join.getTcpIpConfig().addMember("127.0.0.1").setEnabled(true);
        join.getMulticastConfig().setEnabled(false);
        HazelcastInstance h1 = this.hazelcastFactory.newHazelcastInstance(c);
        Member m1 = h1.getCluster().getLocalMember();
        m1.setIntAttribute("Test", 123);
        HazelcastInstance h2 = this.hazelcastFactory.newHazelcastInstance(c);
        Assert.assertEquals((long)2L, (long)h2.getCluster().getMembers().size());
        Member member = null;
        for (Member m : h2.getCluster().getMembers()) {
            if (m == h2.getCluster().getLocalMember()) continue;
            member = m;
        }
        Assert.assertNotNull(member);
        Assert.assertEquals((Object)m1, member);
        Assert.assertNotNull((Object)member.getIntAttribute("Test"));
        Assert.assertEquals((long)123L, (long)member.getIntAttribute("Test").intValue());
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        CountDownLatch latch = new CountDownLatch(3);
        LatchMembershipListener listener = new LatchMembershipListener(latch);
        h2.getCluster().addMembershipListener((MembershipListener)listener);
        h1.getCluster().addMembershipListener((MembershipListener)listener);
        client.getCluster().addMembershipListener((MembershipListener)listener);
        m1.removeAttribute("Test");
        ClientMemberAttributeTest.assertOpenEventually((CountDownLatch)latch);
        Assert.assertNull((Object)member.getIntAttribute("Test"));
        boolean found = false;
        Set members = client.getCluster().getMembers();
        for (Member m : members) {
            if (!m.equals(m1)) continue;
            Assert.assertNull((Object)m.getIntAttribute("Test"));
            found = true;
        }
        Assert.assertTrue((boolean)found);
    }

    private static class LatchMembershipListener
    implements MembershipListener {
        private final CountDownLatch latch;

        private LatchMembershipListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void memberAdded(MembershipEvent membershipEvent) {
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            this.latch.countDown();
        }
    }
}

