/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.Callable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientOwnershipTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void test_clientOwnedByMember() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        String instanceUuid = instance.getLocalEndpoint().getUuid();
        String clientUuid = client.getLocalEndpoint().getUuid();
        ClientEngineImpl clientEngine = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance);
        Assert.assertEquals((Object)instanceUuid, (Object)clientEngine.getOwnerUuid(clientUuid));
    }

    @Test
    public void test_clientOwnedInfoPropagatedToAllMembers() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        final String instanceUuid = instance1.getLocalEndpoint().getUuid();
        final String clientUuid = client.getLocalEndpoint().getUuid();
        final ClientEngineImpl clientEngine1 = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance1);
        final ClientEngineImpl clientEngine2 = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance2);
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((Object)instanceUuid, (Object)clientEngine1.getOwnerUuid(clientUuid));
                Assert.assertEquals((Object)instanceUuid, (Object)clientEngine2.getOwnerUuid(clientUuid));
            }
        });
    }

    @Test
    public void test_clientOwnedBySecondMember_afterFirstOwnerDies() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        instance1.shutdown();
        final String instance2Uuid = instance2.getLocalEndpoint().getUuid();
        final String clientUuid = client.getLocalEndpoint().getUuid();
        final ClientEngineImpl clientEngine = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance2);
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((Object)instance2Uuid, (Object)clientEngine.getOwnerUuid(clientUuid));
            }
        });
    }

    @Test
    public void test_clientOwnedByAlreadyConnectedSecondMember_afterFirstOwnerDies() {
        final HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        final HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        IExecutorService exec = client.getExecutorService("exec");
        exec.submitToAllMembers((Callable)new HazelcastTestSupport.DummySerializableCallable());
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)1L, (long)instance1.getClientService().getConnectedClients().size());
                Assert.assertEquals((long)1L, (long)instance2.getClientService().getConnectedClients().size());
            }
        });
        instance1.shutdown();
        final String instance2Uuid = instance2.getLocalEndpoint().getUuid();
        final String clientUuid = client.getLocalEndpoint().getUuid();
        final ClientEngineImpl clientEngine = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance2);
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((Object)instance2Uuid, (Object)clientEngine.getOwnerUuid(clientUuid));
            }
        });
    }

    @Test
    public void test_ownerShipRemoved_afterClientDies() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        final String instanceUuid = instance1.getLocalEndpoint().getUuid();
        final String clientUuid = client.getLocalEndpoint().getUuid();
        final ClientEngineImpl clientEngine1 = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance1);
        final ClientEngineImpl clientEngine2 = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance2);
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((Object)instanceUuid, (Object)clientEngine1.getOwnerUuid(clientUuid));
                Assert.assertEquals((Object)instanceUuid, (Object)clientEngine2.getOwnerUuid(clientUuid));
            }
        });
        client.shutdown();
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals(null, (Object)clientEngine1.getOwnerUuid(clientUuid));
                Assert.assertEquals(null, (Object)clientEngine2.getOwnerUuid(clientUuid));
            }
        });
    }

    @Test
    public void test_ownerShip_afterClusterRestart() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        final HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        instance.shutdown();
        final HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)1L, (long)client.getCluster().getMembers().size());
                Assert.assertEquals((long)1L, (long)instance2.getCluster().getMembers().size());
            }
        });
        final String instanceUuid = instance2.getLocalEndpoint().getUuid();
        final ClientEngineImpl clientEngine2 = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance2);
        final String clientUuid = client.getLocalEndpoint().getUuid();
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((Object)instanceUuid, (Object)clientEngine2.getOwnerUuid(clientUuid));
            }
        });
    }

    @Test
    public void test_ownerShip_whenSmartClientAndOwnerDiesTogether() {
        this.test_ownerShip_whenClientAndOwnerDiesTogether(true);
    }

    @Test
    public void test_ownerShip_whenNonSmartClientAndOwnerDiesTogether() {
        this.test_ownerShip_whenClientAndOwnerDiesTogether(false);
    }

    private void test_ownerShip_whenClientAndOwnerDiesTogether(boolean smart) {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig config = new ClientConfig();
        config.getNetworkConfig().setSmartRouting(smart);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(config);
        final String clientUuid = client.getLocalEndpoint().getUuid();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        client.getLifecycleService().terminate();
        instance.getLifecycleService().terminate();
        HazelcastInstance instance3 = this.hazelcastFactory.newHazelcastInstance();
        final ClientEngineImpl clientEngine3 = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance3);
        final ClientEngineImpl clientEngine2 = ClientOwnershipTest.getClientEngineImpl((HazelcastInstance)instance2);
        ClientOwnershipTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals(null, (Object)clientEngine2.getOwnerUuid(clientUuid));
                Assert.assertEquals(null, (Object)clientEngine3.getOwnerUuid(clientUuid));
            }
        });
    }
}

