/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipAdapter;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.nio.Address;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientReconnectTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testClientReconnectOnClusterDown() throws Exception {
        HazelcastInstance h1 = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final CountDownLatch connectedLatch = new CountDownLatch(2);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                connectedLatch.countDown();
            }
        });
        IMap m = client.getMap("default");
        h1.shutdown();
        this.hazelcastFactory.newHazelcastInstance();
        ClientReconnectTest.assertOpenEventually((CountDownLatch)connectedLatch);
        Assert.assertNull((Object)m.put((Object)"test", (Object)"test"));
        Assert.assertEquals((Object)"test", (Object)m.get((Object)"test"));
    }

    @Test
    public void testReconnectToNewInstanceAtSameAddress() throws InterruptedException {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        Address localAddress = instance.getCluster().getLocalMember().getAddress();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        final HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final CountDownLatch memberRemovedLatch = new CountDownLatch(1);
        client.getCluster().addMembershipListener((MembershipListener)new MembershipAdapter(){

            public void memberRemoved(MembershipEvent membershipEvent) {
                memberRemovedLatch.countDown();
            }
        });
        instance.shutdown();
        final HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance(localAddress);
        ClientReconnectTest.assertOpenEventually((CountDownLatch)memberRemovedLatch);
        ClientReconnectTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)1L, (long)client.getCluster().getMembers().size());
                Iterator iterator = client.getCluster().getMembers().iterator();
                Member member = (Member)iterator.next();
                Assert.assertEquals((Object)instance2.getCluster().getLocalMember(), (Object)member);
            }
        });
    }

    @Test
    public void testClientShutdownIfReconnectionNotPossible() {
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(1);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final CountDownLatch shutdownLatch = new CountDownLatch(1);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (event.getState() == LifecycleEvent.LifecycleState.SHUTDOWN) {
                    shutdownLatch.countDown();
                }
            }
        });
        server.shutdown();
        ClientReconnectTest.assertOpenEventually((CountDownLatch)shutdownLatch);
    }

    @Test(expected=HazelcastClientNotActiveException.class, timeout=30000L)
    public void testRequestShouldFailOnShutdown() {
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(1);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap test = client.getMap("test");
        test.put((Object)"key", (Object)"value");
        server.shutdown();
        test.get((Object)"key");
    }
}

