/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ClientRegressionWithRealNetworkTest
extends HazelcastTestSupport {
    @After
    public void cleanUp() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void testClientPortConnection() {
        Config config1 = new Config();
        config1.getGroupConfig().setName("foo");
        config1.getNetworkConfig().setPort(5701);
        HazelcastInstance instance1 = Hazelcast.newHazelcastInstance((Config)config1);
        instance1.getMap("map").put((Object)"key", (Object)"value");
        Config config2 = new Config();
        config2.getGroupConfig().setName("bar");
        config2.getNetworkConfig().setPort(5702);
        HazelcastInstance instance2 = Hazelcast.newHazelcastInstance((Config)config2);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getGroupConfig().setName("bar");
        HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        IMap map = client.getMap("map");
        Assert.assertNull((Object)map.put((Object)"key", (Object)"value"));
        Assert.assertEquals((long)1L, (long)map.size());
    }

    @Test
    public void testClientConnectionBeforeServerReady() throws InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                Hazelcast.newHazelcastInstance();
            }
        });
        final CountDownLatch clientLatch = new CountDownLatch(1);
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                ClientConfig config = new ClientConfig();
                config.getNetworkConfig().setConnectionAttemptLimit(10);
                HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)config);
                clientLatch.countDown();
            }
        });
        ClientRegressionWithRealNetworkTest.assertOpenEventually((CountDownLatch)clientLatch);
    }
}

