/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.ClientTestUtil;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientListener;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientServiceTest
extends ClientTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(expected=NullPointerException.class)
    public void testAddClientListener_whenListenerIsNull() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        ClientService clientService = instance.getClientService();
        clientService.addClientListener(null);
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveClientListener_whenIdIsNull() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        ClientService clientService = instance.getClientService();
        clientService.removeClientListener(null);
    }

    @Test(timeout=120000L)
    public void testRemoveClientListener_whenListenerAlreadyRemoved() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        ClientService clientService = instance.getClientService();
        ClientListener clientListener = (ClientListener)Mockito.mock(ClientListener.class);
        String id = clientService.addClientListener(clientListener);
        Assert.assertTrue((boolean)clientService.removeClientListener(id));
        Assert.assertFalse((boolean)clientService.removeClientListener(id));
    }

    @Test(timeout=120000L)
    public void testRemoveClientListener_whenNonExistingId() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        ClientService clientService = instance.getClientService();
        Assert.assertFalse((boolean)clientService.removeClientListener("foobar"));
    }

    @Test(timeout=120000L)
    public void testNumberOfClients_afterUnAuthenticatedClient() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getGroupConfig().setPassword("wrongPassword");
        try {
            this.hazelcastFactory.newHazelcastClient(clientConfig);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)instance.getClientService().getConnectedClients().size());
    }

    @Test(timeout=120000L)
    public void testNumberOfClients_afterUnAuthenticatedClient_withTwoNode() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getGroupConfig().setPassword("wrongPassword");
        try {
            this.hazelcastFactory.newHazelcastClient(clientConfig);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)instance1.getClientService().getConnectedClients().size());
        Assert.assertEquals((long)0L, (long)instance2.getClientService().getConnectedClients().size());
    }

    @Test(timeout=120000L)
    @Category(value={NightlyTest.class})
    public void testNumberOfClients_afterUnAuthenticatedClient_withTwoNode_twoClient() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getGroupConfig().setPassword("wrongPassword");
        try {
            this.hazelcastFactory.newHazelcastClient(clientConfig);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.hazelcastFactory.newHazelcastClient(clientConfig);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)instance1.getClientService().getConnectedClients().size());
        Assert.assertEquals((long)0L, (long)instance2.getClientService().getConnectedClients().size());
    }

    @Test(timeout=120000L)
    public void testConnectedClients() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client1 = this.hazelcastFactory.newHazelcastClient();
        HazelcastInstance client2 = this.hazelcastFactory.newHazelcastClient();
        ClientService clientService = instance.getClientService();
        Collection connectedClients = clientService.getConnectedClients();
        Assert.assertEquals((long)2L, (long)connectedClients.size());
        String uuid1 = client1.getLocalEndpoint().getUuid();
        String uuid2 = client2.getLocalEndpoint().getUuid();
        for (Client connectedClient : connectedClients) {
            String uuid = connectedClient.getUuid();
            Assert.assertTrue((uuid.equals(uuid1) || uuid.equals(uuid2) ? 1 : 0) != 0);
        }
    }

    @Test(timeout=120000L)
    public void testClientListener() throws InterruptedException {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        final ClientService clientService = instance.getClientService();
        final CountDownLatch latchAdd = new CountDownLatch(2);
        final CountDownLatch latchRemove = new CountDownLatch(2);
        final AtomicInteger totalAdd = new AtomicInteger(0);
        ClientListener clientListener = new ClientListener(){

            public void clientConnected(Client client) {
                totalAdd.incrementAndGet();
                latchAdd.countDown();
            }

            public void clientDisconnected(Client client) {
                latchRemove.countDown();
            }
        };
        String id = clientService.addClientListener(clientListener);
        HazelcastInstance client1 = this.hazelcastFactory.newHazelcastClient();
        HazelcastInstance client2 = this.hazelcastFactory.newHazelcastClient();
        client1.getLifecycleService().shutdown();
        client2.getLifecycleService().shutdown();
        ClientServiceTest.assertOpenEventually((CountDownLatch)latchAdd);
        ClientServiceTest.assertOpenEventually((CountDownLatch)latchRemove);
        Assert.assertTrue((boolean)clientService.removeClientListener(id));
        Assert.assertFalse((boolean)clientService.removeClientListener("foo"));
        Assert.assertEquals((long)0L, (long)clientService.getConnectedClients().size());
        this.hazelcastFactory.newHazelcastClient();
        ClientServiceTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)1L, (long)clientService.getConnectedClients().size());
            }
        });
        Assert.assertEquals((long)2L, (long)totalAdd.get());
    }

    @Test(timeout=120000L)
    public void testConnectedClientsWithReAuth() throws InterruptedException {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptPeriod(5000);
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        final CountDownLatch countDownLatch = new CountDownLatch(2);
        clientConfig.addListenerConfig(new ListenerConfig((EventListener)new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (event.getState() == LifecycleEvent.LifecycleState.CLIENT_CONNECTED) {
                    countDownLatch.countDown();
                }
            }
        }));
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        instance.shutdown();
        final HazelcastInstance restartedInstance = this.hazelcastFactory.newHazelcastInstance();
        client.getMap(ClientServiceTest.randomMapName()).size();
        ClientServiceTest.assertOpenEventually((CountDownLatch)countDownLatch);
        ClientServiceTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)1L, (long)restartedInstance.getClientService().getConnectedClients().size());
            }
        });
    }

    @Test(timeout=120000L)
    public void testClientListenerForBothNodes() {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        ClientConnectedListenerLatch clientListenerLatch = new ClientConnectedListenerLatch(2);
        ClientService clientService1 = instance1.getClientService();
        clientService1.addClientListener((ClientListener)clientListenerLatch);
        ClientService clientService2 = instance2.getClientService();
        clientService2.addClientListener((ClientListener)clientListenerLatch);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        String instance1Key = ClientServiceTest.generateKeyOwnedBy((HazelcastInstance)instance1);
        String instance2Key = ClientServiceTest.generateKeyOwnedBy((HazelcastInstance)instance2);
        IMap map = client.getMap("map");
        map.put((Object)instance1Key, (Object)0);
        map.put((Object)instance2Key, (Object)0);
        this.assertClientConnected(clientService1, clientService2);
        ClientServiceTest.assertOpenEventually((CountDownLatch)clientListenerLatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testClientListenerDisconnected() throws InterruptedException {
        Config config = new Config();
        config.setProperty(GroupProperty.IO_THREAD_COUNT.getName(), "1");
        final HazelcastInstance hz = this.hazelcastFactory.newHazelcastInstance(config);
        final HazelcastInstance hz2 = this.hazelcastFactory.newHazelcastInstance(config);
        int clientCount = 10;
        ClientDisconnectedListenerLatch listenerLatch = new ClientDisconnectedListenerLatch(2 * clientCount);
        hz.getClientService().addClientListener((ClientListener)listenerLatch);
        hz2.getClientService().addClientListener((ClientListener)listenerLatch);
        LinkedList<HazelcastInstance> clients = new LinkedList<HazelcastInstance>();
        for (int i = 0; i < clientCount; ++i) {
            HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
            IMap map = client.getMap(ClientServiceTest.randomMapName());
            map.addEntryListener((EntryListener)new EntryAdapter(), true);
            map.put((Object)ClientServiceTest.generateKeyOwnedBy((HazelcastInstance)hz), (Object)"value");
            map.put((Object)ClientServiceTest.generateKeyOwnedBy((HazelcastInstance)hz2), (Object)"value");
            clients.add(client);
        }
        ExecutorService ex = Executors.newFixedThreadPool(4);
        try {
            for (final HazelcastInstance client : clients) {
                ex.execute(new Runnable(){

                    @Override
                    public void run() {
                        client.shutdown();
                    }
                });
            }
            ClientServiceTest.assertOpenEventually((CountDownLatch)listenerLatch);
            ClientServiceTest.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Assert.assertEquals((long)0L, (long)hz.getClientService().getConnectedClients().size());
                }
            });
            ClientServiceTest.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Assert.assertEquals((long)0L, (long)hz2.getClientService().getConnectedClients().size());
                }
            });
        }
        finally {
            ex.shutdown();
        }
    }

    @Test(timeout=120000L)
    public void testPendingEventPacketsWithEvents() throws InterruptedException, UnknownHostException {
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        IMap map = client.getMap(ClientServiceTest.randomName());
        map.addEntryListener((EntryListener)new EntryAdapter(), false);
        for (int i = 0; i < 10; ++i) {
            map.put((Object)ClientServiceTest.randomString(), (Object)ClientServiceTest.randomString());
        }
        HazelcastClientInstanceImpl clientInstanceImpl = ClientTestUtil.getHazelcastClientInstanceImpl(client);
        InetSocketAddress socketAddress = hazelcastInstance.getCluster().getLocalMember().getSocketAddress();
        Address address = new Address(socketAddress.getAddress().getHostAddress(), socketAddress.getPort());
        ClientConnectionManager connectionManager = clientInstanceImpl.getConnectionManager();
        final ClientConnection connection = (ClientConnection)connectionManager.getConnection(address);
        ClientServiceTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)0L, (long)connection.getPendingPacketCount());
            }
        });
    }

    private void assertClientConnected(ClientService ... services) {
        for (final ClientService service : services) {
            ClientServiceTest.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Assert.assertEquals((long)1L, (long)service.getConnectedClients().size());
                }
            });
        }
    }

    @Test
    public void testClientShutdownDuration_whenServersDown() {
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        ClientConfig config = new ClientConfig();
        config.getNetworkConfig().setConnectionAttemptPeriod(0).setConnectionAttemptLimit(1);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(config);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (event.getState() == LifecycleEvent.LifecycleState.SHUTDOWN) {
                    countDownLatch.countDown();
                }
            }
        });
        hazelcastInstance.shutdown();
        ClientServiceTest.assertOpenEventually((CountDownLatch)countDownLatch, (long)30L);
    }

    @Test
    public void testClientListener_fromConfig() {
        Config config = new Config();
        final CountDownLatch connectedLatch = new CountDownLatch(1);
        final CountDownLatch disconnectedLatch = new CountDownLatch(1);
        ListenerConfig listenerConfig = new ListenerConfig((EventListener)new ClientListener(){

            public void clientConnected(Client client) {
                connectedLatch.countDown();
            }

            public void clientDisconnected(Client client) {
                disconnectedLatch.countDown();
            }
        });
        config.addListenerConfig(listenerConfig);
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        client.shutdown();
        ClientServiceTest.assertOpenEventually((CountDownLatch)connectedLatch);
        ClientServiceTest.assertOpenEventually((CountDownLatch)disconnectedLatch);
        instance.shutdown();
    }

    @Test
    public void testClientListener_withDummyClient() {
        Config config = new Config();
        final CountDownLatch latch = new CountDownLatch(2);
        final AtomicInteger eventCount = new AtomicInteger();
        ListenerConfig listenerConfig = new ListenerConfig((EventListener)new ClientListener(){

            public void clientConnected(Client client) {
                eventCount.incrementAndGet();
                latch.countDown();
            }

            public void clientDisconnected(Client client) {
                eventCount.incrementAndGet();
                latch.countDown();
            }
        });
        config.addListenerConfig(listenerConfig);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        client.shutdown();
        ClientServiceTest.assertOpenEventually((CountDownLatch)latch);
        ClientServiceTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)2L, (long)eventCount.get());
            }
        }, (long)4L);
    }

    @Test
    public void testClientListener_withShuttingDownOwnerMember() {
        Config config = new Config();
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger atomicInteger = new AtomicInteger();
        ListenerConfig listenerConfig = new ListenerConfig((EventListener)new ClientListener(){

            public void clientConnected(Client client) {
                atomicInteger.incrementAndGet();
                latch.countDown();
            }

            public void clientDisconnected(Client client) {
            }
        });
        config.addListenerConfig(listenerConfig);
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastClient();
        this.hazelcastFactory.newHazelcastInstance(config);
        ClientServiceTest.assertOpenEventually((CountDownLatch)latch);
        instance.shutdown();
        ClientServiceTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)1L, (long)atomicInteger.get());
            }
        }, (long)4L);
    }

    static class ClientDisconnectedListenerLatch
    extends CountDownLatch
    implements ClientListener {
        public ClientDisconnectedListenerLatch(int count) {
            super(count);
        }

        public void clientConnected(Client client) {
        }

        public void clientDisconnected(Client client) {
            this.countDown();
        }
    }

    static class ClientConnectedListenerLatch
    extends CountDownLatch
    implements ClientListener {
        public ClientConnectedListenerLatch(int count) {
            super(count);
        }

        public void clientConnected(Client client) {
            this.countDown();
        }

        public void clientDisconnected(Client client) {
        }
    }
}

