/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.util.EmptyStatement;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={NightlyTest.class})
public class ClientSplitBrainTest
extends HazelcastTestSupport {
    @After
    public void cleanup() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void testClientListeners_InSplitBrain() throws Throwable {
        Config config = new Config();
        config.setProperty(GroupProperty.MERGE_FIRST_RUN_DELAY_SECONDS.getName(), "5");
        config.setProperty(GroupProperty.MERGE_NEXT_RUN_DELAY_SECONDS.getName(), "5");
        HazelcastInstance h1 = Hazelcast.newHazelcastInstance((Config)config);
        HazelcastInstance h2 = Hazelcast.newHazelcastInstance((Config)config);
        ClientConfig clientConfig = new ClientConfig();
        HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        String mapName = ClientSplitBrainTest.randomMapName();
        IMap mapNode1 = h1.getMap(mapName);
        IMap mapNode2 = h2.getMap(mapName);
        IMap mapClient = client.getMap(mapName);
        AtomicBoolean[] listenerGotEventFlags = new AtomicBoolean[3];
        for (int i = 0; i < 3; ++i) {
            listenerGotEventFlags[i] = new AtomicBoolean();
        }
        CountDownLatch mergedLatch = new CountDownLatch(1);
        LifecycleListener mergeListener = this.createMergeListener(mergedLatch);
        h1.getLifecycleService().addLifecycleListener(mergeListener);
        h2.getLifecycleService().addLifecycleListener(mergeListener);
        EntryAdapter entryListener1 = this.createEntryListener(listenerGotEventFlags[0]);
        mapNode1.addEntryListener((EntryListener)entryListener1, true);
        EntryAdapter entryListener2 = this.createEntryListener(listenerGotEventFlags[1]);
        mapNode2.addEntryListener((EntryListener)entryListener2, true);
        EntryAdapter entryListener3 = this.createEntryListener(listenerGotEventFlags[2]);
        mapClient.addEntryListener((EntryListener)entryListener3, true);
        ClientSplitBrainTest.closeConnectionBetween((HazelcastInstance)h2, (HazelcastInstance)h1);
        ClientSplitBrainTest.assertOpenEventually((CountDownLatch)mergedLatch);
        Assert.assertEquals((long)2L, (long)h1.getCluster().getMembers().size());
        Assert.assertEquals((long)2L, (long)h2.getCluster().getMembers().size());
        AtomicBoolean testFinished = new AtomicBoolean(false);
        Thread clientThread = this.startClientPutThread((IMap<Object, Object>)mapClient, testFinished);
        try {
            this.checkEventsEventually(listenerGotEventFlags);
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            testFinished.set(true);
            clientThread.interrupt();
            clientThread.join();
        }
    }

    private void checkEventsEventually(final AtomicBoolean[] listenerGotEventFlags) {
        int i = 0;
        while (i < listenerGotEventFlags.length) {
            final int id = i++;
            ClientSplitBrainTest.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Assert.assertTrue((String)("listener id " + id), (boolean)listenerGotEventFlags[id].get());
                }
            });
        }
    }

    private Thread startClientPutThread(final IMap<Object, Object> mapClient, final AtomicBoolean testFinished) {
        Thread clientThread = new Thread(){

            @Override
            public void run() {
                while (!testFinished.get()) {
                    try {
                        mapClient.put((Object)1, (Object)1);
                    }
                    catch (Throwable t) {
                        EmptyStatement.ignore((Throwable)t);
                    }
                }
            }
        };
        clientThread.start();
        return clientThread;
    }

    private EntryAdapter createEntryListener(final AtomicBoolean listenerGotEventFlag) {
        return new EntryAdapter(){

            public void onEntryEvent(EntryEvent event) {
                listenerGotEventFlag.set(true);
            }
        };
    }

    private LifecycleListener createMergeListener(final CountDownLatch mergedLatch) {
        return new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (event.getState() == LifecycleEvent.LifecycleState.MERGED) {
                    mergedLatch.countDown();
                }
            }
        };
    }
}

