/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IList;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.junit.After;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientTimeoutTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(timeout=20000L, expected=IllegalStateException.class)
    public void testTimeoutToOutsideNetwork() throws Exception {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getGroupConfig().setName("dev").setPassword("dev-pass");
        clientConfig.getNetworkConfig().addAddress(new String[]{"8.8.8.8:5701"});
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IList list = client.getList("test");
    }

    @Test
    public void testConnectionTimeout_withIntMax() {
        this.testConnectionTimeout(Integer.MAX_VALUE);
    }

    @Test
    public void testConnectionTimeout_withZeroValue() {
        this.testConnectionTimeout(0);
    }

    public void testConnectionTimeout(int timeoutInMillis) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionTimeout(timeoutInMillis);
        this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastClient(clientConfig);
    }

    @Test(expected=OperationTimeoutException.class)
    public void testInvocationTimeOut() throws Throwable {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), "0");
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IExecutorService executorService = client.getExecutorService("test");
        Future future = executorService.submit((Callable)new RetryableExceptionThrowingCallable());
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public static class RetryableExceptionThrowingCallable
    implements Callable,
    Serializable {
        public Object call() throws Exception {
            throw new RetryableHazelcastException();
        }
    }
}

