/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class MembershipListenerTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void whenMemberAdded_thenMemberAddedEvent() throws Exception {
        final HazelcastInstance server1 = this.hazelcastFactory.newHazelcastInstance();
        final MemberShipEventLogger listener = new MemberShipEventLogger();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        client.getCluster().addMembershipListener((MembershipListener)listener);
        final HazelcastInstance server2 = this.hazelcastFactory.newHazelcastInstance();
        MembershipListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertNotEquals((String)"Expecting one or more events", (long)0L, (long)listener.events.size());
                MembershipEvent event = (MembershipEvent)listener.events.getLast();
                Assert.assertEquals((String)"Last event should be member added", (long)1L, (long)event.getEventType());
                Assert.assertEquals((Object)server2.getCluster().getLocalMember(), (Object)event.getMember());
                Assert.assertEquals((Object)MembershipListenerTest.this.getMembers(new HazelcastInstance[]{server1, server2}), (Object)event.getMembers());
            }
        });
    }

    @Test
    public void givenMixOfListenerExists_whenConnect_thenCallInitialMembershipListener() throws Exception {
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig config = new ClientConfig();
        config.addListenerConfig(new ListenerConfig().setImplementation((EventListener)((Object)new MemberShipEventLogger())));
        config.addListenerConfig(new ListenerConfig().setImplementation((EventListener)((Object)new MemberShipEventLogger())));
        config.addListenerConfig(new ListenerConfig().setImplementation((EventListener)((Object)new MemberShipEventLogger())));
        final InitialMemberShipEventLogger initialListener = new InitialMemberShipEventLogger();
        config.addListenerConfig(new ListenerConfig().setImplementation((EventListener)((Object)initialListener)));
        this.hazelcastFactory.newHazelcastClient(config);
        MembershipListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((String)"Expecting one event", (long)1L, (long)initialListener.events.size());
                InitialMembershipEvent event = (InitialMembershipEvent)initialListener.events.getLast();
                Assert.assertEquals((long)1L, (long)event.getMembers().size());
            }
        });
    }

    @Test
    public void whenMemberRemoved_thenMemberRemovedEvent() throws Exception {
        final HazelcastInstance server1 = this.hazelcastFactory.newHazelcastInstance();
        final MemberShipEventLogger listener = new MemberShipEventLogger();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastInstance server2 = this.hazelcastFactory.newHazelcastInstance();
        client.getCluster().addMembershipListener((MembershipListener)listener);
        final Member server2Member = server2.getCluster().getLocalMember();
        server2.shutdown();
        MembershipListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertNotEquals((String)"Expecting one or more events", (long)0L, (long)listener.events.size());
                MembershipEvent event = (MembershipEvent)listener.events.getLast();
                Assert.assertEquals((String)"Last event should be member removed", (long)2L, (long)event.getEventType());
                Assert.assertEquals((Object)server2Member, (Object)event.getMember());
                Assert.assertEquals((Object)MembershipListenerTest.this.getMembers(new HazelcastInstance[]{server1}), (Object)event.getMembers());
            }
        });
    }

    @Test
    public void removedPhantomListener_thenFalse() throws Exception {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        Assert.assertFalse((boolean)client.getCluster().removeMembershipListener(MembershipListenerTest.randomString()));
    }

    @Test(expected=NullPointerException.class)
    public void removedNullListener_thenException() throws Exception {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        Assert.assertFalse((boolean)client.getCluster().removeMembershipListener(null));
    }

    @Test(expected=NullPointerException.class)
    public void addNullListener_thenException() throws Exception {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        client.getCluster().addMembershipListener(null);
    }

    private Set<Member> getMembers(HazelcastInstance ... instances) {
        HashSet<Member> result = new HashSet<Member>();
        for (HazelcastInstance hz : instances) {
            result.add(hz.getCluster().getLocalMember());
        }
        return result;
    }

    @Test
    public void testAddInitialMembership_whenListenerAddedViaClientConfig() throws InterruptedException {
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addListenerConfig(new ListenerConfig().setImplementation((EventListener)Mockito.mock(InitialMembershipListener.class)));
        this.hazelcastFactory.newHazelcastClient(clientConfig);
    }

    @Test
    public void initialMemberEvents_whenAddedViaConfig() throws InterruptedException {
        this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        InitialMemberShipEventLogger listener = new InitialMemberShipEventLogger();
        clientConfig.addListenerConfig(new ListenerConfig().setImplementation((EventListener)((Object)listener)));
        this.hazelcastFactory.newHazelcastClient(clientConfig);
        EventObject eventObject = listener.events.poll(ASSERT_TRUE_EVENTUALLY_TIMEOUT, TimeUnit.SECONDS);
        MembershipListenerTest.assertInstanceOf(InitialMembershipEvent.class, (Object)eventObject);
        InitialMembershipEvent event = (InitialMembershipEvent)eventObject;
        Assert.assertEquals((long)2L, (long)event.getMembers().size());
        Assert.assertEquals((long)0L, (long)listener.events.size());
    }

    @Test
    public void initialMemberEvents_whenAddedAfterClientStarted() throws InterruptedException {
        this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        InitialMemberShipEventLogger listener = new InitialMemberShipEventLogger();
        client.getCluster().addMembershipListener((MembershipListener)listener);
        EventObject eventObject = listener.events.poll(ASSERT_TRUE_EVENTUALLY_TIMEOUT, TimeUnit.SECONDS);
        MembershipListenerTest.assertInstanceOf(InitialMembershipEvent.class, (Object)eventObject);
        InitialMembershipEvent event = (InitialMembershipEvent)eventObject;
        Assert.assertEquals((long)2L, (long)event.getMembers().size());
        Assert.assertEquals((long)0L, (long)listener.events.size());
    }

    @Test
    public void initialMemberEvents_whenClusterRestarted() throws InterruptedException {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        InitialMemberShipEventLogger listener = new InitialMemberShipEventLogger();
        clientConfig.addListenerConfig(new ListenerConfig().setImplementation((EventListener)((Object)listener)));
        this.hazelcastFactory.newHazelcastClient(clientConfig);
        EventObject eventObject = listener.events.poll(ASSERT_TRUE_EVENTUALLY_TIMEOUT, TimeUnit.SECONDS);
        MembershipListenerTest.assertInstanceOf(InitialMembershipEvent.class, (Object)eventObject);
        instance1.getLifecycleService().terminate();
        eventObject = listener.events.poll(ASSERT_TRUE_EVENTUALLY_TIMEOUT, TimeUnit.SECONDS);
        MembershipListenerTest.assertInstanceOf(MembershipEvent.class, (Object)eventObject);
        Assert.assertEquals((long)2L, (long)((MembershipEvent)eventObject).getEventType());
        instance2.getLifecycleService().terminate();
        this.hazelcastFactory.newHazelcastInstance();
        eventObject = listener.events.poll(ASSERT_TRUE_EVENTUALLY_TIMEOUT, TimeUnit.SECONDS);
        MembershipListenerTest.assertInstanceOf(MembershipEvent.class, (Object)eventObject);
        Assert.assertEquals((long)2L, (long)((MembershipEvent)eventObject).getEventType());
        eventObject = listener.events.poll(ASSERT_TRUE_EVENTUALLY_TIMEOUT, TimeUnit.SECONDS);
        MembershipListenerTest.assertInstanceOf(MembershipEvent.class, (Object)eventObject);
        Assert.assertEquals((long)1L, (long)((MembershipEvent)eventObject).getEventType());
    }

    private class InitialMemberShipEventLogger
    implements InitialMembershipListener {
        public LinkedBlockingDeque<EventObject> events = new LinkedBlockingDeque();

        private InitialMemberShipEventLogger() {
        }

        public void memberAdded(MembershipEvent event) {
            this.events.addLast((EventObject)event);
        }

        public void memberRemoved(MembershipEvent event) {
            this.events.addLast((EventObject)event);
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            this.events.addLast((EventObject)memberAttributeEvent);
        }

        public void init(InitialMembershipEvent event) {
            this.events.addLast((EventObject)event);
        }
    }

    private class MemberShipEventLogger
    implements MembershipListener {
        public LinkedBlockingDeque<EventObject> events = new LinkedBlockingDeque();

        private MemberShipEventLogger() {
        }

        public void memberAdded(MembershipEvent event) {
            this.events.addLast((EventObject)event);
        }

        public void memberRemoved(MembershipEvent event) {
            this.events.addLast((EventObject)event);
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
        }
    }
}

