/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.spi.properties.GroupProperty;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Ignore;

@Ignore(value="Not a JUnit test")
public class SimpleMapTestFromClient {
    public static int THREAD_COUNT;
    public static int ENTRY_COUNT;
    public static int VALUE_SIZE;
    public static final int STATS_SECONDS = 10;
    public static int GET_PERCENTAGE;
    public static int PUT_PERCENTAGE;

    public static void main(String[] args) {
        ClientConfig clientConfig = new ClientConfig();
        HazelcastInstance instance1 = Hazelcast.newHazelcastInstance();
        HazelcastInstance instance2 = Hazelcast.newHazelcastInstance();
        final HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        final Stats stats = new Stats();
        if (args != null && args.length > 0) {
            for (String arg : args) {
                if ((arg = arg.trim()).startsWith("t")) {
                    THREAD_COUNT = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("c")) {
                    ENTRY_COUNT = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("v")) {
                    VALUE_SIZE = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("g")) {
                    GET_PERCENTAGE = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (!arg.startsWith("p")) continue;
                PUT_PERCENTAGE = Integer.parseInt(arg.substring(1));
            }
        } else {
            System.out.println("Help: sh test.sh t200 v130 p10 g85 ");
            System.out.println("    // means 200 threads, value-size 130 bytes, 10% put, 85% get");
            System.out.println("");
        }
        System.out.println("Starting Test with ");
        System.out.println("      Thread Count: " + THREAD_COUNT);
        System.out.println("       Entry Count: " + ENTRY_COUNT);
        System.out.println("        Value Size: " + VALUE_SIZE);
        System.out.println("    Get Percentage: " + GET_PERCENTAGE);
        System.out.println("    Put Percentage: " + PUT_PERCENTAGE);
        System.out.println(" Remove Percentage: " + (100 - (PUT_PERCENTAGE + GET_PERCENTAGE)));
        ExecutorService es = Executors.newFixedThreadPool(THREAD_COUNT);
        for (int i = 0; i < THREAD_COUNT; ++i) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    IMap map = client.getMap("default");
                    while (true) {
                        int key = (int)(Math.random() * (double)ENTRY_COUNT);
                        int operation = (int)(Math.random() * 100.0);
                        if (operation < GET_PERCENTAGE) {
                            map.get((Object)String.valueOf(key));
                            stats.gets.incrementAndGet();
                            continue;
                        }
                        if (operation < GET_PERCENTAGE + PUT_PERCENTAGE) {
                            map.put((Object)String.valueOf(key), (Object)new byte[VALUE_SIZE]);
                            stats.puts.incrementAndGet();
                            continue;
                        }
                        map.remove((Object)String.valueOf(key));
                        stats.removes.incrementAndGet();
                    }
                }
            });
        }
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(10000L);
                            System.out.println("cluster size:" + client.getCluster().getMembers().size());
                            Stats currentStats = stats.getAndReset();
                            System.out.println(currentStats);
                            System.out.println("Operations per Second : " + currentStats.total() / 10L);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
    }

    static {
        GroupProperty.WAIT_SECONDS_BEFORE_JOIN.setSystemProperty("0");
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperty("hazelcast.local.localAddress", "127.0.0.1");
        GroupProperty.PHONE_HOME_ENABLED.setSystemProperty("false");
        GroupProperty.SOCKET_BIND_ANY.setSystemProperty("false");
        Random rand = new Random();
        int g1 = rand.nextInt(255);
        int g2 = rand.nextInt(255);
        int n = rand.nextInt(255);
        THREAD_COUNT = 40;
        ENTRY_COUNT = 10000;
        VALUE_SIZE = 1000;
        GET_PERCENTAGE = 40;
        PUT_PERCENTAGE = 40;
    }

    public static class Stats {
        public AtomicLong puts = new AtomicLong();
        public AtomicLong gets = new AtomicLong();
        public AtomicLong removes = new AtomicLong();

        public Stats getAndReset() {
            long putsNow = this.puts.getAndSet(0L);
            long getsNow = this.gets.getAndSet(0L);
            long removesNow = this.removes.getAndSet(0L);
            Stats newOne = new Stats();
            newOne.puts.set(putsNow);
            newOne.gets.set(getsNow);
            newOne.removes.set(removesNow);
            return newOne;
        }

        public long total() {
            return this.puts.get() + this.gets.get() + this.removes.get();
        }

        public String toString() {
            return "total= " + this.total() + ", gets:" + this.gets.get() + ", puts: " + this.puts.get() + ", removes:" + this.removes.get();
        }
    }
}

