/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.aggregation;

import com.hazelcast.aggregation.AggregatorsSpecTest;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.experimental.categories.Category;

@Category(value={QuickTest.class, ParallelTest.class})
public class ClientAggregatorsSpecTest
extends AggregatorsSpecTest {
    private TestHazelcastFactory factory;

    protected <K, V> IMap<K, V> getMapWithNodeCount(int nodeCount, boolean parallelAccumulation) {
        if (nodeCount < 1) {
            throw new IllegalArgumentException("node count < 1");
        }
        MapConfig mapConfig = new MapConfig().setName("aggr").setInMemoryFormat(this.inMemoryFormat);
        Config config = new Config().setProperty(GroupProperty.PARTITION_COUNT.getName(), String.valueOf(nodeCount)).setProperty(GroupProperty.AGGREGATION_ACCUMULATION_PARALLEL_EVALUATION.getName(), String.valueOf(parallelAccumulation)).addMapConfig(mapConfig);
        this.factory = new TestHazelcastFactory();
        for (int i = 0; i < nodeCount; ++i) {
            this.factory.newHazelcastInstance(config);
        }
        HazelcastInstance instance = this.factory.newHazelcastClient();
        return instance.getMap("aggr");
    }

    @After
    public void teardown() {
        this.factory.terminateAll();
    }
}

