/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.atomiclong;

import com.hazelcast.client.UndefinedErrorCodeException;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IFunction;
import com.hazelcast.test.ExpectedRuntimeException;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientAtomicLongTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;
    private IAtomicLong l;

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
        this.l = this.client.getAtomicLong(ClientAtomicLongTest.randomString());
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void test() throws Exception {
        Assert.assertEquals((long)0L, (long)this.l.getAndAdd(2L));
        Assert.assertEquals((long)2L, (long)this.l.get());
        this.l.set(5L);
        Assert.assertEquals((long)5L, (long)this.l.get());
        Assert.assertEquals((long)8L, (long)this.l.addAndGet(3L));
        Assert.assertFalse((boolean)this.l.compareAndSet(7L, 4L));
        Assert.assertEquals((long)8L, (long)this.l.get());
        Assert.assertTrue((boolean)this.l.compareAndSet(8L, 4L));
        Assert.assertEquals((long)4L, (long)this.l.get());
        Assert.assertEquals((long)3L, (long)this.l.decrementAndGet());
        Assert.assertEquals((long)3L, (long)this.l.getAndIncrement());
        Assert.assertEquals((long)4L, (long)this.l.getAndSet(9L));
        Assert.assertEquals((long)10L, (long)this.l.incrementAndGet());
    }

    @Test
    public void testAsync() throws Exception {
        ICompletableFuture future = this.l.getAndAddAsync(10L);
        Assert.assertEquals((long)0L, (long)((Long)future.get()));
        ICompletableFuture booleanFuture = this.l.compareAndSetAsync(10L, 42L);
        Assert.assertTrue((boolean)((Boolean)booleanFuture.get()));
        future = this.l.getAsync();
        Assert.assertEquals((long)42L, (long)((Long)future.get()));
        future = this.l.incrementAndGetAsync();
        Assert.assertEquals((long)43L, (long)((Long)future.get()));
        future = this.l.addAndGetAsync(-13L);
        Assert.assertEquals((long)30L, (long)((Long)future.get()));
        future = this.l.alterAndGetAsync((IFunction)new AddOneFunction());
        Assert.assertEquals((long)31L, (long)((Long)future.get()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void apply_whenCalledWithNullFunction() {
        IAtomicLong ref = this.client.getAtomicLong("apply_whenCalledWithNullFunction");
        ref.apply(null);
    }

    @Test
    public void apply() {
        IAtomicLong ref = this.client.getAtomicLong("apply");
        Assert.assertEquals((Object)new Long(1L), (Object)ref.apply((IFunction)new AddOneFunction()));
        Assert.assertEquals((long)0L, (long)ref.get());
    }

    @Test
    public void applyAsync() throws ExecutionException, InterruptedException {
        IAtomicLong ref = this.client.getAtomicLong("apply");
        ICompletableFuture future = ref.applyAsync((IFunction)new AddOneFunction());
        Assert.assertEquals((Object)new Long(1L), (Object)future.get());
        Assert.assertEquals((long)0L, (long)ref.get());
    }

    @Test
    public void applyBooleanAsync() throws ExecutionException, InterruptedException {
        final CountDownLatch cdl = new CountDownLatch(1);
        final IAtomicLong ref = this.client.getAtomicLong("apply");
        ICompletableFuture incAndGetFuture = ref.setAsync(1L);
        final AtomicBoolean failed = new AtomicBoolean(true);
        incAndGetFuture.andThen((ExecutionCallback)new ExecutionCallback<Void>(){

            public void onResponse(Void response) {
                ICompletableFuture future = ref.applyAsync((IFunction)new FilterOnesFunction());
                try {
                    Assert.assertEquals((Object)Boolean.TRUE, (Object)future.get());
                    failed.set(false);
                    cdl.countDown();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }

            public void onFailure(Throwable t) {
                t.printStackTrace();
            }
        });
        if (cdl.await(15L, TimeUnit.SECONDS)) {
            Assert.assertEquals((long)1L, (long)ref.get());
            Assert.assertEquals((Object)false, (Object)failed.get());
        } else {
            Assert.fail((String)"Timeout after 15 seconds");
        }
    }

    @Test
    public void apply_whenException() {
        IAtomicLong ref = this.client.getAtomicLong("apply_whenException");
        ref.set(1L);
        try {
            ref.apply((IFunction)new FailingFunction());
            Assert.fail();
        }
        catch (UndefinedErrorCodeException expected) {
            Assert.assertEquals((Object)expected.getOriginClassName(), (Object)ExpectedRuntimeException.class.getName());
        }
        Assert.assertEquals((long)1L, (long)ref.get());
    }

    @Test
    public void applyAsync_whenException() {
        IAtomicLong ref = this.client.getAtomicLong("applyAsync_whenException");
        ref.set(1L);
        try {
            ICompletableFuture future = ref.applyAsync((IFunction)new FailingFunction());
            future.get();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(e.getCause().getClass(), UndefinedErrorCodeException.class);
            Assert.assertEquals((Object)((UndefinedErrorCodeException)e.getCause()).getOriginClassName(), (Object)ExpectedRuntimeException.class.getName());
        }
        Assert.assertEquals((long)1L, (long)ref.get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void alter_whenCalledWithNullFunction() {
        IAtomicLong ref = this.client.getAtomicLong("alter_whenCalledWithNullFunction");
        ref.alter(null);
    }

    @Test
    public void alter_whenException() {
        IAtomicLong ref = this.client.getAtomicLong("alter_whenException");
        ref.set(10L);
        try {
            ref.alter((IFunction)new FailingFunction());
            Assert.fail();
        }
        catch (UndefinedErrorCodeException expected) {
            Assert.assertEquals((Object)expected.getOriginClassName(), (Object)ExpectedRuntimeException.class.getName());
        }
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void alterAsync_whenException() {
        IAtomicLong ref = this.client.getAtomicLong("alterAsync_whenException");
        ref.set(10L);
        try {
            ICompletableFuture future = ref.alterAsync((IFunction)new FailingFunction());
            future.get();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(e.getCause().getClass(), UndefinedErrorCodeException.class);
            Assert.assertEquals((Object)((UndefinedErrorCodeException)e.getCause()).getOriginClassName(), (Object)ExpectedRuntimeException.class.getName());
        }
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void alter() {
        IAtomicLong ref = this.client.getAtomicLong("alter");
        ref.set(10L);
        ref.alter((IFunction)new AddOneFunction());
        Assert.assertEquals((long)11L, (long)ref.get());
    }

    @Test
    public void alterAsync() throws ExecutionException, InterruptedException {
        IAtomicLong ref = this.client.getAtomicLong("alterAsync");
        ref.set(10L);
        ICompletableFuture future = ref.alterAsync((IFunction)new AddOneFunction());
        future.get();
        Assert.assertEquals((long)11L, (long)ref.get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void alterAndGet_whenCalledWithNullFunction() {
        IAtomicLong ref = this.client.getAtomicLong("alterAndGet_whenCalledWithNullFunction");
        ref.alterAndGet(null);
    }

    @Test
    public void alterAndGet_whenException() {
        IAtomicLong ref = this.client.getAtomicLong("alterAndGet_whenException");
        ref.set(10L);
        try {
            ref.alterAndGet((IFunction)new FailingFunction());
            Assert.fail();
        }
        catch (UndefinedErrorCodeException expected) {
            Assert.assertEquals((Object)expected.getOriginClassName(), (Object)ExpectedRuntimeException.class.getName());
        }
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void alterAndGetAsync_whenException() {
        IAtomicLong ref = this.client.getAtomicLong("alterAndGetAsync_whenException");
        ref.set(10L);
        try {
            ICompletableFuture future = ref.alterAndGetAsync((IFunction)new FailingFunction());
            future.get();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        catch (ExecutionException e) {
            Assert.assertEquals(e.getCause().getClass(), UndefinedErrorCodeException.class);
            Assert.assertEquals((Object)((UndefinedErrorCodeException)e.getCause()).getOriginClassName(), (Object)ExpectedRuntimeException.class.getName());
        }
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void alterAndGet() {
        IAtomicLong ref = this.client.getAtomicLong("alterAndGet");
        ref.set(10L);
        Assert.assertEquals((long)11L, (long)ref.alterAndGet((IFunction)new AddOneFunction()));
        Assert.assertEquals((long)11L, (long)ref.get());
    }

    @Test
    public void alterAndGetAsync() throws ExecutionException, InterruptedException {
        IAtomicLong ref = this.client.getAtomicLong("alterAndGetAsync");
        ICompletableFuture future = ref.setAsync(10L);
        future.get();
        Assert.assertEquals((long)11L, (long)((Long)ref.alterAndGetAsync((IFunction)new AddOneFunction()).get()));
        Assert.assertEquals((long)11L, (long)ref.get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void getAndAlter_whenCalledWithNullFunction() {
        IAtomicLong ref = this.client.getAtomicLong("getAndAlter_whenCalledWithNullFunction");
        ref.getAndAlter(null);
    }

    @Test
    public void getAndAlter_whenException() {
        IAtomicLong ref = this.client.getAtomicLong("getAndAlter_whenException");
        ref.set(10L);
        try {
            ref.getAndAlter((IFunction)new FailingFunction());
            Assert.fail();
        }
        catch (UndefinedErrorCodeException expected) {
            Assert.assertEquals((Object)expected.getOriginClassName(), (Object)ExpectedRuntimeException.class.getName());
        }
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void getAndAlterAsync_whenException() {
        IAtomicLong ref = this.client.getAtomicLong("getAndAlterAsync_whenException");
        ref.set(10L);
        try {
            ICompletableFuture future = ref.getAndAlterAsync((IFunction)new FailingFunction());
            future.get();
            Assert.fail();
        }
        catch (InterruptedException e) {
            Assert.assertEquals((Object)e.getCause().getClass().getName(), (Object)UndefinedErrorCodeException.class.getName());
            Assert.assertEquals((Object)((UndefinedErrorCodeException)e.getCause()).getOriginClassName(), (Object)ExpectedRuntimeException.class.getName());
        }
        catch (ExecutionException e) {
            Assert.assertEquals((Object)e.getCause().getClass().getName(), (Object)UndefinedErrorCodeException.class.getName());
            Assert.assertEquals((Object)((UndefinedErrorCodeException)e.getCause()).getOriginClassName(), (Object)ExpectedRuntimeException.class.getName());
        }
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void getAndAlter() {
        IAtomicLong ref = this.client.getAtomicLong("getAndAlter");
        ref.set(10L);
        Assert.assertEquals((long)10L, (long)ref.getAndAlter((IFunction)new AddOneFunction()));
        Assert.assertEquals((long)11L, (long)ref.get());
    }

    @Test
    public void getAndAlterAsync() throws ExecutionException, InterruptedException {
        IAtomicLong ref = this.client.getAtomicLong("getAndAlterAsync");
        ref.set(10L);
        ICompletableFuture future = ref.getAndAlterAsync((IFunction)new AddOneFunction());
        Assert.assertEquals((long)10L, (long)((Long)future.get()));
        Assert.assertEquals((long)11L, (long)ref.get());
    }

    private static class FailingFunction
    implements IFunction<Long, Long> {
        private FailingFunction() {
        }

        public Long apply(Long input) {
            throw new ExpectedRuntimeException();
        }
    }

    private static class FilterOnesFunction
    implements IFunction<Long, Boolean> {
        private FilterOnesFunction() {
        }

        public Boolean apply(Long input) {
            return input.equals(1L);
        }
    }

    private static class AddOneFunction
    implements IFunction<Long, Long> {
        private AddOneFunction() {
        }

        public Long apply(Long input) {
            return input + 1L;
        }
    }
}

