/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.atomicreference;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.IFunction;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientAtomicReferenceTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private IAtomicReference<String> clientReference;
    private IAtomicReference<String> serverReference;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        String name = ClientAtomicReferenceTest.randomString();
        this.clientReference = client.getAtomicReference(name);
        this.serverReference = server.getAtomicReference(name);
    }

    @Test
    public void get() throws Exception {
        Assert.assertNull((Object)this.clientReference.get());
        this.serverReference.set((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)this.clientReference.get());
    }

    @Test
    public void isNull() throws Exception {
        Assert.assertTrue((boolean)this.clientReference.isNull());
        this.serverReference.set((Object)"foo");
        Assert.assertFalse((boolean)this.clientReference.isNull());
    }

    @Test
    public void contains() {
        Assert.assertTrue((boolean)this.clientReference.contains(null));
        Assert.assertFalse((boolean)this.clientReference.contains((Object)"foo"));
        this.serverReference.set((Object)"foo");
        Assert.assertFalse((boolean)this.clientReference.contains(null));
        Assert.assertTrue((boolean)this.clientReference.contains((Object)"foo"));
        Assert.assertFalse((boolean)this.clientReference.contains((Object)"bar"));
    }

    @Test
    public void set() throws Exception {
        this.clientReference.set(null);
        Assert.assertTrue((boolean)this.serverReference.isNull());
        this.clientReference.set((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)this.serverReference.get());
        this.clientReference.set((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)this.serverReference.get());
        this.clientReference.set((Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)this.serverReference.get());
        this.clientReference.set(null);
        Assert.assertTrue((boolean)this.serverReference.isNull());
    }

    @Test
    public void clear() throws Exception {
        this.clientReference.clear();
        Assert.assertTrue((boolean)this.serverReference.isNull());
        this.serverReference.set((Object)"foo");
        this.clientReference.clear();
        Assert.assertTrue((boolean)this.serverReference.isNull());
    }

    @Test
    public void getAndSet() throws Exception {
        Assert.assertNull((Object)this.clientReference.getAndSet(null));
        Assert.assertTrue((boolean)this.serverReference.isNull());
        Assert.assertNull((Object)this.clientReference.getAndSet((Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)this.serverReference.get());
        Assert.assertEquals((Object)"foo", (Object)this.clientReference.getAndSet((Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)this.serverReference.get());
        Assert.assertEquals((Object)"foo", (Object)this.clientReference.getAndSet((Object)"bar"));
        Assert.assertEquals((Object)"bar", (Object)this.serverReference.get());
        Assert.assertEquals((Object)"bar", (Object)this.clientReference.getAndSet(null));
        Assert.assertTrue((boolean)this.serverReference.isNull());
    }

    @Test
    public void setAndGet() throws Exception {
        Assert.assertNull((Object)this.clientReference.setAndGet(null));
        Assert.assertTrue((boolean)this.serverReference.isNull());
        Assert.assertEquals((Object)"foo", (Object)this.clientReference.setAndGet((Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)this.serverReference.get());
        Assert.assertEquals((Object)"foo", (Object)this.clientReference.setAndGet((Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)this.serverReference.get());
        Assert.assertEquals((Object)"bar", (Object)this.clientReference.setAndGet((Object)"bar"));
        Assert.assertEquals((Object)"bar", (Object)this.serverReference.get());
        Assert.assertNull((Object)this.clientReference.setAndGet(null));
        Assert.assertTrue((boolean)this.serverReference.isNull());
    }

    @Test
    public void compareAndSet() throws Exception {
        Assert.assertTrue((boolean)this.clientReference.compareAndSet(null, null));
        Assert.assertTrue((boolean)this.serverReference.isNull());
        Assert.assertFalse((boolean)this.clientReference.compareAndSet((Object)"foo", null));
        Assert.assertTrue((boolean)this.serverReference.isNull());
        Assert.assertTrue((boolean)this.clientReference.compareAndSet(null, (Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)this.serverReference.get());
        Assert.assertTrue((boolean)this.clientReference.compareAndSet((Object)"foo", (Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)this.serverReference.get());
        Assert.assertFalse((boolean)this.clientReference.compareAndSet((Object)"bar", (Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)this.serverReference.get());
        Assert.assertTrue((boolean)this.clientReference.compareAndSet((Object)"foo", (Object)"bar"));
        Assert.assertEquals((Object)"bar", (Object)this.serverReference.get());
        Assert.assertTrue((boolean)this.clientReference.compareAndSet((Object)"bar", null));
        Assert.assertNull((Object)this.serverReference.get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void apply_whenCalledWithNullFunction() {
        this.clientReference.apply(null);
    }

    @Test
    public void apply() {
        Assert.assertEquals((Object)"null", (Object)this.clientReference.apply((IFunction)new AppendFunction("")));
        Assert.assertEquals(null, (Object)this.clientReference.get());
        this.clientReference.set((Object)"foo");
        Assert.assertEquals((Object)"foobar", (Object)this.clientReference.apply((IFunction)new AppendFunction("bar")));
        Assert.assertEquals((Object)"foo", (Object)this.clientReference.get());
        Assert.assertEquals(null, (Object)this.clientReference.apply((IFunction)new NullFunction()));
        Assert.assertEquals((Object)"foo", (Object)this.clientReference.get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void alter_whenCalledWithNullFunction() {
        this.clientReference.alter(null);
    }

    @Test
    public void alter() {
        this.clientReference.alter((IFunction)new NullFunction());
        Assert.assertEquals(null, (Object)this.clientReference.get());
        this.clientReference.set((Object)"foo");
        this.clientReference.alter((IFunction)new AppendFunction("bar"));
        Assert.assertEquals((Object)"foobar", (Object)this.clientReference.get());
        this.clientReference.alter((IFunction)new NullFunction());
        Assert.assertEquals(null, (Object)this.clientReference.get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void alterAndGet_whenCalledWithNullFunction() {
        this.clientReference.alterAndGet(null);
    }

    @Test
    public void alterAndGet() {
        Assert.assertNull((Object)this.clientReference.alterAndGet((IFunction)new NullFunction()));
        Assert.assertEquals(null, (Object)this.clientReference.get());
        this.clientReference.set((Object)"foo");
        Assert.assertEquals((Object)"foobar", (Object)this.clientReference.alterAndGet((IFunction)new AppendFunction("bar")));
        Assert.assertEquals((Object)"foobar", (Object)this.clientReference.get());
        Assert.assertEquals(null, (Object)this.clientReference.alterAndGet((IFunction)new NullFunction()));
        Assert.assertEquals(null, (Object)this.clientReference.get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void getAndAlter_whenCalledWithNullFunction() {
        this.clientReference.alterAndGet(null);
    }

    @Test
    public void getAndAlter() {
        Assert.assertNull((Object)this.clientReference.getAndAlter((IFunction)new NullFunction()));
        Assert.assertEquals(null, (Object)this.clientReference.get());
        this.clientReference.set((Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)this.clientReference.getAndAlter((IFunction)new AppendFunction("bar")));
        Assert.assertEquals((Object)"foobar", (Object)this.clientReference.get());
        Assert.assertEquals((Object)"foobar", (Object)this.clientReference.getAndAlter((IFunction)new NullFunction()));
        Assert.assertEquals(null, (Object)this.clientReference.get());
    }

    private static class NullFunction
    implements IFunction<String, String> {
        private NullFunction() {
        }

        public String apply(String input) {
            return null;
        }
    }

    private static class AppendFunction
    implements IFunction<String, String> {
        private String add;

        private AppendFunction(String add) {
            this.add = add;
        }

        public String apply(String input) {
            return input + this.add;
        }
    }
}

