/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache;

import com.hazelcast.cache.CacheListenerTest;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.cache.ClientCacheEntryExpiredLatchCountdownListener;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.HazelcastInstanceFactory;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.spi.CachingProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class CacheClientListenerTest
extends CacheListenerTest {
    @Before
    @After
    public void cleanup() {
        HazelcastClient.shutdownAll();
        HazelcastInstanceFactory.terminateAll();
    }

    protected CachingProvider getCachingProvider() {
        Config config = new Config();
        JoinConfig joinConfig = config.getNetworkConfig().getJoin();
        joinConfig.getAwsConfig().setEnabled(false);
        joinConfig.getMulticastConfig().setEnabled(false);
        joinConfig.getTcpIpConfig().setEnabled(false);
        Hazelcast.newHazelcastInstance((Config)config);
        Hazelcast.newHazelcastInstance((Config)config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().addAddress(new String[]{"127.0.0.1"});
        this.hazelcastInstance = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        return HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)this.hazelcastInstance);
    }

    @Test
    public void testEntryListenerUsingMemberConfig() {
        System.setProperty("hazelcast.config", "classpath:hazelcast-cache-entrylistener-test.xml");
        Hazelcast.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().addAddress(new String[]{"127.0.0.1"});
        HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        HazelcastClientCachingProvider cachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
        CacheManager cacheManager = cachingProvider.getCacheManager();
        Cache cache = cacheManager.getCache("entrylistenertestcache");
        cache.put((Object)"foo", (Object)"bar");
        HazelcastInstance client2 = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        HazelcastClientCachingProvider cachingProvider2 = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client2);
        CacheManager cacheManager2 = cachingProvider2.getCacheManager();
        Cache cache2 = cacheManager2.getCache("entrylistenertestcache");
        client.shutdown();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        cache2.get((Object)"foo");
        final CountDownLatch expiredLatch = ClientCacheEntryExpiredLatchCountdownListener.getExpiredLatch();
        CacheClientListenerTest.assertCountEventually((String)"The expired event should only be received one time", (int)1, (CountDownLatch)expiredLatch, (long)3L);
        CacheClientListenerTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((String)"Expired event is received more than once", (long)1L, (long)expiredLatch.getCount());
            }
        }, (long)3L);
    }
}

