/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache;

import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.HazelcastInstanceFactory;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.TestUtil;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ClientCacheConfigTest {
    private final URL configUrl1 = this.getClass().getClassLoader().getResource("hazelcast-client-c1.xml");
    private final URL configUrl2 = this.getClass().getClassLoader().getResource("hazelcast-client-c2.xml");
    private final CacheSimpleConfig simpleConfig = new CacheSimpleConfig().setName("pre-configured-cache");

    @BeforeClass
    public static void setupClass() {
        HazelcastClient.shutdownAll();
    }

    @Before
    public void init() {
        Config config = new Config();
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config.getNetworkConfig().setPort(5701);
        config.getGroupConfig().setName("cluster1");
        config.getGroupConfig().setPassword("cluster1pass");
        config.addCacheConfig(this.simpleConfig);
        Hazelcast.newHazelcastInstance((Config)config);
        Config config2 = new Config();
        config2.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config2.getNetworkConfig().setPort(5702);
        config2.getGroupConfig().setName("cluster2");
        config2.getGroupConfig().setPassword("cluster2pass");
        config.addCacheConfig(this.simpleConfig);
        Hazelcast.newHazelcastInstance((Config)config2);
    }

    @After
    public void tearDown() {
        HazelcastClient.shutdownAll();
        HazelcastInstanceFactory.terminateAll();
    }

    @Test
    public void cacheManagerByLocationClasspathTest() throws URISyntaxException {
        Assert.assertEquals((long)0L, (long)HazelcastClient.getAllHazelcastClients().size());
        URI uri1 = new URI("MY-SCOPE");
        Properties properties = new Properties();
        properties.setProperty("hazelcast.config.location", "classpath:hazelcast-client-c1.xml");
        CacheManager cacheManager = Caching.getCachingProvider().getCacheManager(uri1, null, properties);
        Assert.assertNotNull((Object)cacheManager);
        Assert.assertEquals((long)1L, (long)HazelcastClient.getAllHazelcastClients().size());
        Caching.getCachingProvider().close();
        cacheManager.close();
        Assert.assertEquals((long)0L, (long)HazelcastClient.getAllHazelcastClients().size());
    }

    @Test
    public void cacheManagerByLocationFileTest() throws URISyntaxException {
        Assert.assertEquals((long)0L, (long)HazelcastClient.getAllHazelcastClients().size());
        URI uri = new URI("MY-SCOPE");
        String urlStr = this.configUrl1.toString();
        Assert.assertEquals((Object)"file", (Object)urlStr.substring(0, 4));
        Properties properties = new Properties();
        properties.setProperty("hazelcast.config.location", urlStr);
        CacheManager cacheManager = Caching.getCachingProvider().getCacheManager(uri, null, properties);
        Assert.assertNotNull((Object)cacheManager);
        URI uri2 = new URI("MY-SCOPE-OTHER");
        String urlStr2 = this.configUrl2.toString();
        Assert.assertEquals((Object)"file", (Object)urlStr2.substring(0, 4));
        Properties properties2 = new Properties();
        properties2.setProperty("hazelcast.config.location", urlStr2);
        CacheManager cacheManager2 = Caching.getCachingProvider().getCacheManager(uri2, null, properties2);
        Assert.assertNotNull((Object)cacheManager2);
        Assert.assertEquals((long)2L, (long)HazelcastClient.getAllHazelcastClients().size());
        Caching.getCachingProvider().close();
    }

    @Test
    public void cacheManagerByInstanceNameTest() throws URISyntaxException {
        Assert.assertEquals((long)0L, (long)HazelcastClient.getAllHazelcastClients().size());
        String instanceName = "ClientInstanceTest";
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getGroupConfig().setName("cluster1");
        clientConfig.getGroupConfig().setPassword("cluster1pass");
        clientConfig.setInstanceName(instanceName);
        HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        Assert.assertEquals((Object)instanceName, (Object)client.getName());
        URI uri1 = new URI("MY-SCOPE");
        Properties properties = new Properties();
        properties.setProperty("hazelcast.instance.name", instanceName);
        CacheManager cacheManager = Caching.getCachingProvider().getCacheManager(uri1, null, properties);
        Assert.assertNotNull((Object)cacheManager);
        Assert.assertEquals((long)1L, (long)HazelcastClient.getAllHazelcastClients().size());
        client.shutdown();
        Caching.getCachingProvider().close();
    }

    @Test
    public void testGetPreConfiguredCache() {
        ClientConfig config = new ClientConfig();
        config.getGroupConfig().setName("cluster1");
        config.getGroupConfig().setPassword("cluster1pass");
        for (int i = 0; i < 4; ++i) {
            HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)config);
            HazelcastClientCachingProvider provider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
            CacheManager cacheManager = provider.getCacheManager();
            Cache cache = cacheManager.getCache(this.simpleConfig.getName());
            Assert.assertNotNull((String)("Cache cannot be retrieved on client: " + i), (Object)cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createCacheConfigOnAllNodes() {
        String CACHE_NAME = "myCache";
        HazelcastInstance client = null;
        HazelcastInstance server1 = null;
        HazelcastInstance server2 = null;
        try {
            Config config = new Config();
            CacheSimpleConfig cacheSimpleConfig = new CacheSimpleConfig().setName("myCache").setBackupCount(1);
            config.addCacheConfig(cacheSimpleConfig);
            server1 = Hazelcast.newHazelcastInstance((Config)config);
            server2 = Hazelcast.newHazelcastInstance((Config)config);
            ICacheService cacheService1 = this.getCacheService(server1);
            ICacheService cacheService2 = this.getCacheService(server2);
            client = HazelcastClient.newHazelcastClient();
            HazelcastClientCachingProvider cachingProvider = HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)client);
            CacheManager cacheManager = cachingProvider.getCacheManager();
            Cache cache = cacheManager.getCache("myCache");
            Assert.assertNotNull((Object)cache);
            CacheConfig cacheConfig = (CacheConfig)cache.getConfiguration(CacheConfig.class);
            Assert.assertNotNull((Object)cacheService1.getCacheConfig(cacheConfig.getNameWithPrefix()));
            Assert.assertNotNull((Object)cacheService2.getCacheConfig(cacheConfig.getNameWithPrefix()));
            cache.put((Object)"key", (Object)"value");
        }
        finally {
            if (client != null) {
                client.shutdown();
            }
            if (server1 != null) {
                server1.shutdown();
            }
            if (server2 != null) {
                server2.shutdown();
            }
        }
    }

    private ICacheService getCacheService(HazelcastInstance instance) {
        Node node = TestUtil.getNode((HazelcastInstance)instance);
        return (ICacheService)node.getNodeEngine().getService("hz:impl:cacheService");
    }
}

