/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache;

import com.hazelcast.cache.CacheContextTest;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import javax.cache.spi.CachingProvider;
import org.junit.After;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheContextTest
extends CacheContextTest {
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    protected CachingProvider initAndGetCachingProvider() {
        this.hazelcastInstance1 = this.factory.newHazelcastInstance();
        this.hazelcastInstance2 = this.factory.newHazelcastInstance();
        this.driverInstance = this.factory.newHazelcastClient();
        return HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)this.driverInstance);
    }

    @After
    public void tearDown() {
        this.driverInstance.shutdown();
        this.hazelcastInstance1.shutdown();
        this.hazelcastInstance2.shutdown();
    }

    @Test
    public void cacheEntryListenerCountIncreasedAfterRegisterAndDecreasedAfterDeregister() {
        this.cacheEntryListenerCountIncreasedAndDecreasedCorrectly(CacheContextTest.DecreaseType.DEREGISTER);
    }

    @Test
    public void cacheEntryListenerCountIncreasedAfterRegisterAndDecreasedAfterShutdown() {
        this.cacheEntryListenerCountIncreasedAndDecreasedCorrectly(CacheContextTest.DecreaseType.SHUTDOWN);
    }

    @Test
    public void cacheEntryListenerCountIncreasedAfterRegisterAndDecreasedAfterTerminate() {
        this.cacheEntryListenerCountIncreasedAndDecreasedCorrectly(CacheContextTest.DecreaseType.TERMINATE);
    }
}

