/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache;

import com.hazelcast.cache.CacheReadWriteThroughTest;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.CacheConfiguration;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.spi.CachingProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCacheReadWriteThroughTest
extends CacheReadWriteThroughTest {
    private CachingProvider serverCachingProvider;

    protected CachingProvider createCachingProvider(HazelcastInstance instance) {
        return HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)instance);
    }

    protected TestHazelcastInstanceFactory createInstanceFactory(int instanceCount) {
        return new TestHazelcastFactory();
    }

    protected HazelcastInstance getInstance() {
        HazelcastInstance serverInstance = this.factory.newHazelcastInstance(this.createConfig());
        this.serverCachingProvider = HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)serverInstance);
        return ((TestHazelcastFactory)this.factory).newHazelcastClient();
    }

    protected void onTearDown() {
        this.serverCachingProvider.close();
    }

    @Test
    public void test_cacheLoaderIsUsedOnlyAtServerSide() {
        String cacheName = ClientCacheReadWriteThroughTest.randomName();
        CacheManager serverCacheManager = this.serverCachingProvider.getCacheManager();
        CacheConfiguration config = new CacheConfig().setTypes(Integer.class, String.class).setReadThrough(true).setCacheLoaderFactory((Factory)new ServerSideCacheLoaderFactory());
        serverCacheManager.createCache(cacheName, (Configuration)config);
        CacheManager clientCacheManager = this.cachingProvider.getCacheManager();
        Cache cache = clientCacheManager.getCache(cacheName, Integer.class, String.class);
        Assert.assertNotNull((Object)cache);
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int i = 0; i < 100; ++i) {
            keys.add(i);
        }
        Map loaded = cache.getAll(keys);
        Assert.assertEquals((long)keys.size(), (long)loaded.size());
        for (Map.Entry entry : loaded.entrySet()) {
            Assert.assertEquals((Object)ServerSideCacheLoader.valueOf((Integer)entry.getKey()), entry.getValue());
        }
    }

    private static class ServerSideCacheLoader
    implements CacheLoader<Integer, String> {
        private ServerSideCacheLoader() {
        }

        static String valueOf(Integer key) {
            return "value-of-" + key;
        }

        public String load(Integer key) {
            return ServerSideCacheLoader.valueOf(key);
        }

        public Map<Integer, String> loadAll(Iterable<? extends Integer> keys) throws CacheLoaderException {
            HashMap<Integer, String> result = new HashMap<Integer, String>();
            for (Integer n : keys) {
                String value = this.load(n);
                result.put(n, value);
            }
            return result;
        }
    }

    public static class ServerSideCacheLoaderFactory
    implements Factory<ServerSideCacheLoader>,
    HazelcastInstanceAware {
        private transient HazelcastInstance hazelcastInstance;

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.hazelcastInstance = hazelcastInstance;
        }

        public ServerSideCacheLoader create() {
            if (this.hazelcastInstance instanceof HazelcastInstanceImpl) {
                return new ServerSideCacheLoader();
            }
            throw new IllegalStateException("This factory can only be used at server side!");
        }
    }
}

