/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache;

import com.hazelcast.cache.CachingProviderTest;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.cache.spi.CachingProvider;
import org.junit.After;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ClientCachingProviderTest
extends CachingProviderTest {
    private final List<HazelcastInstance> instances = new ArrayList<HazelcastInstance>();

    @Before
    public void setup() {
        Config config = new Config();
        config.getGroupConfig().setName("test-group1");
        config.getGroupConfig().setPassword("test-pass1");
        HazelcastInstance instance = Hazelcast.newHazelcastInstance((Config)config);
        this.instances.add(instance);
        this.instance1 = this.createHazelcastInstance(INSTANCE_1_NAME);
        this.instance2 = this.createHazelcastInstance(INSTANCE_2_NAME);
        try {
            this.instance3 = HazelcastClient.newHazelcastClient((ClientConfig)new XmlClientConfigBuilder("test-hazelcast-jcache.xml").build());
        }
        catch (IOException e) {
            throw new AssertionError((Object)("Could not construct named hazelcast client instance: " + e.getMessage()));
        }
        this.instances.add(this.instance1);
        this.instances.add(this.instance2);
        this.instances.add(this.instance3);
        this.cachingProvider = this.createCachingProvider(this.instance1);
    }

    protected HazelcastInstance createHazelcastInstance(String instanceName) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setInstanceName(instanceName);
        clientConfig.getGroupConfig().setName("test-group1");
        clientConfig.getGroupConfig().setPassword("test-pass1");
        HazelcastInstance instance = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        this.instances.add(instance);
        return instance;
    }

    protected CachingProvider createCachingProvider(HazelcastInstance defaultInstance) {
        return HazelcastClientCachingProvider.createCachingProvider((HazelcastInstance)defaultInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() {
        Iterator<HazelcastInstance> iter = this.instances.iterator();
        while (iter.hasNext()) {
            HazelcastInstance instance = iter.next();
            try {
                instance.shutdown();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                iter.remove();
            }
        }
    }
}

