/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache;

import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
@Ignore
public class ClientManagerTest {
    final URI uri1 = new File("hazelcast-client/src/test/java/com/hazelcast/client/cache/hazelcast-client-c1.xml").toURI();
    final URI uri2 = new File("hazelcast-client/src/test/java/com/hazelcast/client/cache/hazelcast-client-c2.xml").toURI();

    @Before
    public void init() {
        Config config = new Config();
        config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config.getNetworkConfig().setPort(5701);
        config.getGroupConfig().setName("cluster1");
        config.getGroupConfig().setPassword("cluster1pass");
        HazelcastInstance hz1 = Hazelcast.newHazelcastInstance((Config)config);
        Config config2 = new Config();
        config2.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        config2.getNetworkConfig().setPort(5702);
        config2.getGroupConfig().setName("cluster2");
        config2.getGroupConfig().setPassword("cluster2pass");
        HazelcastInstance hz2 = Hazelcast.newHazelcastInstance((Config)config2);
    }

    public void tearDown() {
        Hazelcast.shutdownAll();
    }

    @Test
    public void testMultiClusterMultipleClients() throws MalformedURLException, URISyntaxException {
        String cacheName = "test";
        String key1 = "key1";
        String valuecm1 = "Value-is-cm1";
        String valuecm2 = "Value-is-cm2";
        HazelcastClientCachingProvider cachingProvider = new HazelcastClientCachingProvider();
        CacheManager cm1 = cachingProvider.getCacheManager(this.uri1, null);
        CacheManager cm2 = cachingProvider.getCacheManager(this.uri2, null);
        CacheConfig cacheConfig = new CacheConfig();
        Cache cache1 = cm1.createCache("test", (Configuration)cacheConfig);
        Cache cache2 = cm2.createCache("test", (Configuration)cacheConfig);
        cache1.put((Object)"key1", (Object)"Value-is-cm1");
        cache2.put((Object)"key1", (Object)"Value-is-cm2");
        Assert.assertEquals((Object)"Value-is-cm1", (Object)cache1.get((Object)"key1"));
        Assert.assertEquals((Object)"Value-is-cm2", (Object)cache2.get((Object)"key1"));
        cachingProvider.close(this.uri1, null);
        cachingProvider.close(this.uri2, null);
        CacheManager cm11 = cachingProvider.getCacheManager(this.uri1, null);
        Cache cache11 = cm11.getCache("test");
        Assert.assertEquals((Object)"Value-is-cm1", (Object)cache11.get((Object)"key1"));
        cm11.close();
    }
}

